/*
 * Decompiled with CFR 0.152.
 */
package javazoom.upload;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javazoom.upload.Archiver;
import javazoom.upload.DBStore;
import javazoom.upload.DefaultOverwriteFilter;
import javazoom.upload.MultipartFormDataRequest;
import javazoom.upload.OverwriteFilter;
import javazoom.upload.UploadException;
import javazoom.upload.UploadFile;
import javazoom.upload.UploadListener;
import javazoom.upload.UploadParameters;

public class UploadBean
implements Serializable {
    public static final int DATABASESTORE = 2;
    public static final String EMPTYENTRY = "EmptyFile";
    public static final int FOLDERSTORE = 1;
    public static boolean INSERTASBYTES;
    public static final int MAXUPLOADEDFILES = -1;
    public static final long MAXUPLOADEDFILESIZE = 0x40000000L;
    public static final int MEMORYSTORE = 0;
    public static char SEPARATOR;
    public static final int SERIALIZEDFILESTORE = 5;
    public static String SQLUPLOADFILE;
    public static String SQLUPLOADFILENAME;
    public static String SQLUPLOADFILESIZE;
    public static String SQLUPLOADFILETYPE;
    public static String SQLUPLOADID;
    public static String SQLUPLOADTABLE;
    public static final int TARGZIPFILESTORE = 4;
    public static int TRANSFERBUFFERSIZE;
    public static final String VERSION = "UploadBean 1.9";
    public static final int XMLFILESTORE = 6;
    public static final int ZIPFILESTORE = 3;
    private Vector _$425 = null;
    private String _$438 = "javazoom.upload.DefaultDBStore";
    private DBStore _$440 = null;
    private boolean _$434 = false;
    private HashMap _$437 = null;
    private boolean _$427 = true;
    private String _$435 = null;
    private Vector _$444 = new Vector();
    private Vector _$443 = new Vector();
    private long _$429 = 0x40000000L;
    private int _$428 = -1;
    private boolean _$430 = false;
    private OverwriteFilter _$432 = null;
    private String _$433 = null;
    private Vector _$445 = null;
    private int _$424 = 0;
    private Vector _$426 = null;
    private String _$436 = null;

    static {
        SEPARATOR = (char)47;
        TRANSFERBUFFERSIZE = 4096;
        SQLUPLOADTABLE = "UPLOADS";
        SQLUPLOADID = "UPLOADID";
        SQLUPLOADFILENAME = "FILENAME";
        SQLUPLOADFILE = "BINARYFILE";
        SQLUPLOADFILESIZE = "FILESIZE";
        SQLUPLOADFILETYPE = "FILETYPE";
        INSERTASBYTES = false;
    }

    public UploadBean() {
        this._$425 = new Vector();
        this._$426 = new Vector();
        SEPARATOR = System.getProperty("file.separator").charAt(0);
        this._$445 = new Vector();
        this._$432 = new DefaultOverwriteFilter();
        this._$432.init("filenametimestamp");
        this._$437 = new HashMap();
    }

    public void addUploadListener(UploadListener uploadListener) {
        if (this._$443 != null) {
            this._$443.addElement(uploadListener);
        }
    }

    private boolean _$533(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this._$425.size()) {
            String string2 = (String)this._$425.elementAt(n);
            String string3 = "";
            String string4 = "";
            int n2 = string2.lastIndexOf(".");
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2 + 1, string2.length());
            }
            String string5 = "";
            String string6 = "";
            n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                string5 = string.substring(0, n2);
                string6 = string.substring(n2 + 1, string.length());
            }
            if (string3.equals("*") && string4.equalsIgnoreCase(string6)) {
                bl = true;
                break;
            }
            if (string4.equals("*") && string3.equalsIgnoreCase(string5)) {
                bl = true;
                break;
            }
            if (string2.equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean _$544(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this._$426.size()) {
            String string2 = (String)this._$426.elementAt(n);
            String string3 = "";
            String string4 = "";
            int n2 = string2.lastIndexOf(".");
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2 + 1, string2.length());
            }
            String string5 = "";
            String string6 = "";
            n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                string5 = string.substring(0, n2);
                string6 = string.substring(n2 + 1, string.length());
            }
            if (string3.equals("*") && string4.equalsIgnoreCase(string6)) {
                bl = true;
                break;
            }
            if (string4.equals("*") && string3.equalsIgnoreCase(string5)) {
                bl = true;
                break;
            }
            if (string2.equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public long computeCRC32(File file, long l) {
        long l2 = -1L;
        CRC32 cRC32 = new CRC32();
        this._$520(file, l, cRC32);
        l2 = cRC32.getValue();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$520(File file, long l, Object object) {
        InputStream inputStream = null;
        if (l < 0L) {
            l = file.length() + 1L;
        }
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[1024];
            int n = -1;
            long l2 = 0L;
            while ((n = inputStream.read(byArray)) > 0) {
                if ((l2 += (long)n) < l) {
                    if (object instanceof CRC32) {
                        ((CRC32)object).update(byArray, 0, n);
                        continue;
                    }
                    if (!(object instanceof MessageDigest)) continue;
                    ((MessageDigest)object).update(byArray, 0, n);
                    continue;
                }
                if (object instanceof CRC32) {
                    ((CRC32)object).update(byArray, 0, n - (int)(l2 - l));
                } else if (object instanceof MessageDigest) {
                    ((MessageDigest)object).update(byArray, 0, n - (int)(l2 - l));
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] computeMD5(File file, long l) {
        byte[] byArray = null;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            this._$520(file, l, messageDigest);
            byArray = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return byArray;
    }

    public String getBlacklist() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._$425.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            String string = (String)this._$425.elementAt(n);
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Connection getDatabasestore() {
        if (this._$440 != null) {
            return this._$440.getConnection();
        }
        return null;
    }

    public DBStore getDatabasestoreimplementation() {
        return this._$440;
    }

    public boolean getDump() {
        return this._$434;
    }

    public long getFilesizelimit() {
        return this._$429;
    }

    public String getFolderstore() {
        return this._$435;
    }

    public Vector getHistory() {
        return this._$444;
    }

    public int getMaxfiles() {
        return this._$428;
    }

    public Vector getMemorystore() {
        return this._$445;
    }

    public boolean getOverwrite() {
        return this._$430;
    }

    public String getOverwritepolicy() {
        return this._$433;
    }

    public String getParser() {
        return MultipartFormDataRequest.DEFAULTPARSER;
    }

    public String getParsertmpdir() {
        return MultipartFormDataRequest.PARSERTEMPDIRECTORY;
    }

    public String getWhitelist() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._$426.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            String string = (String)this._$426.elementAt(n);
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getZipfilestore() {
        return this._$436;
    }

    public String hexDump(byte[] byArray) {
        String string = null;
        byte by = 0;
        int n = 0;
        if (byArray != null && byArray.length > 0) {
            String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            while (n < byArray.length) {
                by = (byte)(byArray[n] & 0xF0);
                by = (byte)(by >>> 4);
                by = (byte)(by & 0xF);
                stringBuffer.append(stringArray[by]);
                by = (byte)(byArray[n] & 0xF);
                stringBuffer.append(stringArray[by]);
                ++n;
            }
            string = new String(stringBuffer);
        }
        return string;
    }

    private void _$480() throws UploadException {
        if (this._$438 != null) {
            try {
                DBStore dBStore;
                Class<?> clazz = Class.forName(this._$438);
                Class<?> clazz2 = clazz.getSuperclass();
                if (!clazz2.getName().equals("javazoom.upload.DBStore")) {
                    throw new UploadException("Wrong super class " + this._$438);
                }
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                this._$440 = dBStore = (DBStore)constructor.newInstance(null);
            }
            catch (Exception exception) {
                throw new UploadException("DBStore error " + exception.getMessage());
            }
        }
    }

    public boolean isBlacklistEnabled() {
        return this._$427;
    }

    private boolean _$548(String string) {
        if (this._$427) {
            return this._$533(string);
        }
        return !this._$544(string);
    }

    public OverwriteFilter loadOverwriteFilter() {
        return this._$432;
    }

    private void _$576(UploadParameters uploadParameters, UploadFile uploadFile) {
        int n = 0;
        while (n < this._$443.size()) {
            UploadListener uploadListener = (UploadListener)this._$443.elementAt(n);
            uploadListener.fileUploaded(uploadParameters, uploadFile);
            ++n;
        }
    }

    public void resetStore() throws UploadException, IOException {
        if (this._$424 == 1 && this._$435 != null) {
            File file = new File(this._$435 + SEPARATOR);
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new UploadException(UploadException.FOLDERISREADONLY);
                }
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    int n = 0;
                    while (n < fileArray.length) {
                        if (!fileArray[n].delete()) {
                            throw new UploadException(UploadException.CANNOTDELETESTORE);
                        }
                        ++n;
                    }
                }
                this.setFolderstore(this._$435);
                this._$444.removeAllElements();
            }
        } else if (this._$424 == 3 && this._$436 != null) {
            File file = new File(this._$436);
            if (!file.delete()) {
                throw new UploadException(UploadException.CANNOTDELETESTORE);
            }
            this.setZipfilestore(this._$436);
            this._$444.removeAllElements();
        } else if (this._$424 == 0 && this._$445 != null) {
            int n = 0;
            while (n < this._$445.size()) {
                UploadFile uploadFile = (UploadFile)this._$445.elementAt(n);
                uploadFile.reset();
                ++n;
            }
            this._$445.removeAllElements();
            this._$444.removeAllElements();
        } else if (this._$424 == 2) {
            try {
                this._$440.reset();
            }
            catch (Exception exception) {
                throw new UploadException(UploadException.DATABASESTOREERROR + " " + exception.getMessage());
            }
            this._$444.removeAllElements();
        }
    }

    public void setBlacklist(String string) {
        this._$425 = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            this._$425.addElement(string2);
        }
        this._$427 = true;
    }

    public void setDatabasestore(Connection connection) throws Exception {
        this.setStoremodel(2);
        this._$480();
        this._$440.connect(connection, null, null);
    }

    public void setDatabasestore(String string, String string2, Properties properties) throws Exception {
        this.setStoremodel(2);
        this._$480();
        this._$440.connect(string, string2, properties);
    }

    public void setDatabasestoreimplementation(String string) throws UploadException {
        this._$438 = string;
    }

    public void setDump(boolean bl) {
        this._$434 = bl;
    }

    public void setFilesizelimit(long l) {
        this._$429 = l;
    }

    public void setFolderstore(String string) throws UploadException {
        this.setStoremodel(1);
        this._$435 = string;
        this._$435 = this._$435.replace('\\', '/').replace('/', SEPARATOR);
        File file = new File(this._$435 + SEPARATOR);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new UploadException(UploadException.FOLDERISREADONLY);
            }
        } else if (!file.mkdirs()) {
            throw new UploadException(UploadException.CANNOTCREATEFOLDER);
        }
    }

    public void setMaxfiles(int n) {
        this._$428 = n;
    }

    public void setMemorystore() throws UploadException {
        this.setStoremodel(0);
    }

    public void setOverwrite(boolean bl) {
        this._$430 = bl;
    }

    public void setOverwritepolicy(String string) {
        this._$433 = string;
        this._$432.init(this._$433);
    }

    public void setParser(String string) {
        MultipartFormDataRequest.DEFAULTPARSER = string;
    }

    public void setParsertmpdir(String string) {
        if (string != null) {
            MultipartFormDataRequest.PARSERTEMPDIRECTORY = string = string.replace('\\', '/').replace('/', SEPARATOR);
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
    }

    public void setStoremodel(int n) throws UploadException {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            throw new UploadException(UploadException.UNKNOWNSTOREMODEL);
        }
        this._$424 = n;
    }

    public void setWhitelist(String string) {
        this._$426 = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            this._$426.addElement(string2);
        }
        this._$427 = false;
    }

    public void setZipfilestore(String string) throws UploadException, IOException {
        this.setStoremodel(3);
        string = string.replace('\\', '/').replace('/', SEPARATOR);
        File file = new File(string);
        this._$436 = string;
        if (!file.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry(EMPTYENTRY));
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            fileOutputStream.close();
        }
    }

    public void store(MultipartFormDataRequest multipartFormDataRequest) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.store(multipartFormDataRequest, string);
        }
    }

    public void store(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        this.store(multipartFormDataRequest, string, null);
    }

    public void store(MultipartFormDataRequest multipartFormDataRequest, String string, Map map) throws UploadException, IOException {
        if (this._$424 == 1 && this._$435 != null) {
            this._$551(multipartFormDataRequest, string);
        } else if (this._$424 == 3 && this._$436 != null) {
            this._$552(multipartFormDataRequest, string);
        } else if (this._$424 == 0 && this._$445 != null) {
            this._$553(multipartFormDataRequest, string);
        } else if (this._$424 == 2) {
            if (map == null) {
                map = this._$437;
            }
            this._$554(multipartFormDataRequest, string, map);
        }
    }

    private void _$554(MultipartFormDataRequest multipartFormDataRequest, String string, Map hashMap) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$429) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            if (this._$548(uploadFile.getFileName())) {
                throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
            }
            int n = this._$440.countFiles();
            if (this._$428 != -1 && n >= this._$428) {
                throw new UploadException(UploadException.UPLOADLIMITREACHED);
            }
            String string2 = multipartFormDataRequest.getRequest().getHeader("Content-Range");
            if (string2 != null) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.put("Content-Range", string2);
            }
            this._$440.store(uploadFile, this._$430, hashMap);
            UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 2, "database", null);
            this._$444.addElement(uploadParameters);
            this._$576(uploadParameters, uploadFile);
        }
    }

    private void _$551(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile != null && uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$429) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            File file = new File(this.getFolderstore() + SEPARATOR);
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (fileArray[n2].getName().equals(uploadFile.getFileName())) {
                    bl = true;
                }
                ++n2;
            }
            if (this._$428 == -1 || n < this._$428) {
                Object object;
                if (this._$548(uploadFile.getFileName())) {
                    throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
                }
                Object object2 = null;
                String string2 = null;
                if (!bl) {
                    object2 = !this._$434 ? new FileOutputStream(this.getFolderstore() + SEPARATOR + uploadFile.getFileName()) : new File(this.getFolderstore() + SEPARATOR + uploadFile.getFileName());
                } else {
                    object = multipartFormDataRequest.getRequest().getHeader("Content-Range");
                    if (object != null) {
                        object = ((String)object).substring(6, ((String)object).length());
                        object = ((String)object).substring(0, ((String)object).indexOf("-"));
                        try {
                            long l = Long.parseLong((String)object);
                            object2 = new RandomAccessFile(this.getFolderstore() + SEPARATOR + uploadFile.getFileName(), "rw");
                            ((RandomAccessFile)object2).seek(l);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new UploadException(UploadException.CANNOTPARSECONTENTRANGE);
                        }
                    } else if (!this._$430) {
                        string2 = this._$432.process(uploadFile.getFileName());
                        object2 = !this._$434 ? new FileOutputStream(this.getFolderstore() + SEPARATOR + string2) : new File(this.getFolderstore() + SEPARATOR + string2);
                    } else {
                        object2 = !this._$434 ? new FileOutputStream(this.getFolderstore() + SEPARATOR + uploadFile.getFileName()) : new File(this.getFolderstore() + SEPARATOR + uploadFile.getFileName());
                    }
                }
                if (this._$434 && object2 instanceof File) {
                    uploadFile.saveAs((File)object2);
                } else {
                    object = uploadFile.getInpuStream();
                    byte[] byArray = new byte[TRANSFERBUFFERSIZE];
                    int n3 = 0;
                    while ((n3 = ((InputStream)object).read(byArray)) != -1) {
                        if (object2 instanceof FileOutputStream) {
                            ((FileOutputStream)object2).write(byArray, 0, n3);
                            continue;
                        }
                        if (!(object2 instanceof RandomAccessFile)) continue;
                        ((RandomAccessFile)object2).write(byArray, 0, n3);
                    }
                    if (object2 instanceof FileOutputStream) {
                        ((FileOutputStream)object2).close();
                    } else if (object2 instanceof RandomAccessFile) {
                        ((RandomAccessFile)object2).close();
                    }
                    ((InputStream)object).close();
                }
                object2 = null;
                object = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 1, this._$435, string2);
                this._$444.addElement(object);
                this._$576((UploadParameters)object, uploadFile);
            } else {
                throw new UploadException(UploadException.UPLOADLIMITREACHED);
            }
        }
    }

    private void _$553(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$429) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            if (this._$548(uploadFile.getFileName())) {
                throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
            }
            if (this._$428 != -1 && this._$445.size() >= this._$428) {
                throw new UploadException(UploadException.UPLOADLIMITREACHED);
            }
            this._$445.addElement(uploadFile);
            UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 0, "memory", null);
            this._$444.addElement(uploadParameters);
            this._$576(uploadParameters, uploadFile);
        }
    }

    private void _$552(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$429) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            if (this._$548(uploadFile.getFileName())) {
                throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
            }
            Archiver archiver = Archiver.getInstance();
            String string2 = null;
            string2 = archiver.append(this._$436, uploadFile, this._$428, this._$430, this._$432);
            UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 3, this._$436, string2);
            this._$444.addElement(uploadParameters);
            this._$576(uploadParameters, uploadFile);
        }
    }

    public void updateOverwriteFilter(OverwriteFilter overwriteFilter) {
        this._$432 = overwriteFilter;
    }
}

