/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;

    AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        int n = 1;
        while (n <= this.reader.getNumberOfPages()) {
            PdfDictionary pdfDictionary2 = this.reader.getPageN(n);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
            if (pdfArray != null) {
                ArrayList arrayList = pdfArray.getArrayList();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(n2));
                    if (PdfName.WIDGET.equals(pdfDictionary3.get(PdfName.SUBTYPE))) {
                        Object object;
                        PdfDictionary pdfDictionary4 = pdfDictionary3;
                        PdfDictionary pdfDictionary5 = new PdfDictionary();
                        pdfDictionary5.putAll(pdfDictionary3);
                        String string = "";
                        PdfDictionary pdfDictionary6 = null;
                        while (pdfDictionary3 != null) {
                            pdfDictionary5.mergeDifferent(pdfDictionary3);
                            object = (PdfString)pdfDictionary3.get(PdfName.T);
                            if (object != null) {
                                string = ((PdfString)object).toUnicodeString() + "." + string;
                            }
                            if (pdfDictionary6 == null && pdfDictionary3.get(PdfName.V) != null) {
                                pdfDictionary6 = pdfDictionary3;
                            }
                            pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.PARENT));
                        }
                        if (string.length() > 0) {
                            string = string.substring(0, string.length() - 1);
                        }
                        if ((object = (Item)this.fields.get(string)) == null) {
                            object = new Item();
                            this.fields.put(string, object);
                        }
                        if (pdfDictionary6 == null) {
                            ((Item)object).values.add(pdfDictionary4);
                        } else {
                            ((Item)object).values.add(pdfDictionary6);
                        }
                        ((Item)object).widgets.add(pdfDictionary4);
                        if (pdfDictionary != null) {
                            pdfDictionary5.mergeDifferent(pdfDictionary);
                        }
                        ((Item)object).merged.add(pdfDictionary5);
                        ((Item)object).page.add(new Integer(n));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    PdfAppearance getAppearance(PdfDictionary pdfDictionary, String string) throws IOException, DocumentException {
        Object object;
        PdfObject pdfObject;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.topFirst = 0;
        TextField textField = new TextField(this.writer, null, null);
        PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DA));
        if (pdfString != null) {
            PRIndirectReference pRIndirectReference;
            object5 = new PRTokeniser(PdfEncodings.convertToBytes(pdfString.toUnicodeString(), null));
            object4 = new ArrayList();
            object3 = null;
            while (((PRTokeniser)object5).nextToken()) {
                if (((PRTokeniser)object5).getTokenType() == 4) continue;
                if (((PRTokeniser)object5).getTokenType() == 10) {
                    float f;
                    float f2;
                    float f3;
                    object2 = ((PRTokeniser)object5).getStringValue();
                    if (((String)object2).equals("Tf")) {
                        if (((ArrayList)object4).size() >= 2) {
                            object3 = (String)((ArrayList)object4).get(((ArrayList)object4).size() - 2);
                            textField.setFontSize(Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1)));
                        }
                    } else if (((String)object2).equals("g")) {
                        if (((ArrayList)object4).size() >= 1 && (f3 = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1))) != 0.0f) {
                            textField.setTextColor(new GrayColor(f3));
                        }
                    } else if (((String)object2).equals("rg")) {
                        if (((ArrayList)object4).size() >= 3) {
                            f3 = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 3));
                            f2 = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 2));
                            f = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1));
                            textField.setTextColor(new Color(f3, f2, f));
                        }
                    } else if (((String)object2).equals("k") && ((ArrayList)object4).size() >= 4) {
                        f3 = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 4));
                        f2 = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 3));
                        f = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 2));
                        float f4 = Float.parseFloat((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1));
                        textField.setTextColor(new CMYKColor(f3, f2, f, f4));
                    }
                    ((ArrayList)object4).clear();
                    continue;
                }
                ((ArrayList)object4).add(((PRTokeniser)object5).getStringValue());
            }
            if (object3 != null && (object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DR))) != null && (object2 = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.FONT))) != null && (pRIndirectReference = (PRIndirectReference)((PdfDictionary)object2).get(new PdfName((String)object3))) != null) {
                textField.setFont(new DocumentFont(pRIndirectReference));
            }
        }
        if ((object5 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK))) != null) {
            object4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.BC));
            textField.setBorderColor(this.getMKColor((PdfArray)object4));
            object4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.BG));
            textField.setBackgroundColor(this.getMKColor((PdfArray)object4));
            object3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.R));
            if (object3 != null) {
                textField.setRotation(((PdfNumber)object3).intValue());
            }
        }
        int n = 0;
        object3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF));
        if (object3 != null) {
            n = ((PdfNumber)object3).intValue();
        }
        textField.setOptions((n & 0x1000) == 0 ? 0 : 4);
        object3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.Q));
        if (object3 != null) {
            if (((PdfNumber)object3).intValue() == 1) {
                textField.setAlignment(1);
            } else if (((PdfNumber)object3).intValue() == 2) {
                textField.setAlignment(2);
            }
        }
        if ((object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BS))) != null) {
            PdfName pdfName;
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.W));
            if (pdfObject != null) {
                textField.setBorderWidth(((PdfNumber)pdfObject).floatValue());
            }
            if (PdfName.D.equals(pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.S)))) {
                textField.setBorderStyle(1);
            } else if (PdfName.B.equals(pdfName)) {
                textField.setBorderStyle(2);
            } else if (PdfName.I.equals(pdfName)) {
                textField.setBorderStyle(3);
            } else if (PdfName.U.equals(pdfName)) {
                textField.setBorderStyle(4);
            }
        } else {
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BORDER));
            if (pdfObject != null) {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                if (arrayList.size() >= 3) {
                    textField.setBorderWidth(((PdfNumber)arrayList.get(2)).floatValue());
                }
                if (arrayList.size() >= 4) {
                    textField.setBorderStyle(1);
                }
            }
        }
        pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
        Rectangle rectangle = PdfReader.getNormalizedRectangle((PdfArray)pdfObject);
        if (textField.getRotation() == 90 || textField.getRotation() == 270) {
            rectangle = rectangle.rotate();
        }
        textField.setBox(rectangle);
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT));
        if (PdfName.TX.equals(pdfName)) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MAXLEN));
            int n2 = 0;
            if (pdfNumber != null) {
                n2 = pdfNumber.intValue();
            }
            if (n2 > 0) {
                string = string.substring(0, Math.min(n2, string.length()));
            }
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfName)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        if ((n & 0x20000) != 0) {
            textField.setText(string);
            return textField.getAppearance();
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        boolean bl = false;
        if (pdfArray != null) {
            object = pdfArray.getArrayList();
            String[] stringArray = new String[((ArrayList)object).size()];
            String[] stringArray2 = new String[((ArrayList)object).size()];
            int n3 = 0;
            while (n3 < ((ArrayList)object).size()) {
                PdfObject pdfObject2 = (PdfObject)((ArrayList)object).get(n3);
                if (pdfObject2.type() == 3) {
                    stringArray[n3] = stringArray2[n3] = ((PdfString)pdfObject2).toUnicodeString();
                } else {
                    ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                    stringArray2[n3] = ((PdfString)arrayList.get(0)).toUnicodeString();
                    stringArray[n3] = ((PdfString)arrayList.get(1)).toUnicodeString();
                }
                ++n3;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < stringArray.length) {
                if (string.equals(stringArray[n5])) {
                    n4 = n5;
                    break;
                }
                ++n5;
            }
            textField.setChoices(stringArray);
            textField.setChoiceExports(stringArray2);
            textField.setChoiceSelection(n4);
        }
        object = textField.getListAppearance();
        this.topFirst = textField.getTopFirst();
        return object;
    }

    Color getMKColor(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        switch (arrayList.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)arrayList.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue(), ((PdfNumber)arrayList.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        if (pdfObject.type() == 3) {
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        HashMap hashMap = fdfReader.getFields();
        Iterator iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(pdfName) || PdfName.CH.equals(pdfName)) {
            PdfString pdfString = new PdfString(string2, "UnicodeBig");
            int n = 0;
            while (n < item.values.size()) {
                PdfObject pdfObject;
                ((PdfDictionary)item.values.get(n)).put(PdfName.V, pdfString);
                PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n);
                pdfDictionary.put(PdfName.V, pdfString);
                PdfAppearance pdfAppearance = this.getAppearance(pdfDictionary, string3);
                PdfDictionary pdfDictionary2 = (PdfDictionary)item.widgets.get(n);
                if (PdfName.CH.equals(pdfName)) {
                    pdfObject = new PdfNumber(this.topFirst);
                    pdfDictionary2.put(PdfName.TI, pdfObject);
                    pdfDictionary.put(PdfName.TI, pdfObject);
                }
                if ((pdfObject = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.AP))) == null) {
                    pdfObject = new PdfDictionary();
                    pdfDictionary2.put(PdfName.AP, pdfObject);
                    pdfDictionary.put(PdfName.AP, pdfObject);
                }
                ((PdfDictionary)pdfObject).put(PdfName.N, pdfAppearance.getIndirectReference());
                ++n;
            }
            return true;
        }
        if (PdfName.BTN.equals(pdfName)) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int n = 0;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            if ((n & 0x10000) != 0) {
                return true;
            }
            PdfName pdfName2 = new PdfName(string2);
            if ((n & 0x8000) == 0) {
                int n2 = 0;
                while (n2 < item.values.size()) {
                    ((PdfDictionary)item.values.get(n2)).put(PdfName.V, pdfName2);
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n2);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    pdfDictionary.put(PdfName.AS, pdfName2);
                    PdfDictionary pdfDictionary3 = (PdfDictionary)item.widgets.get(n2);
                    pdfDictionary3.put(PdfName.AS, pdfName2);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < item.values.size()) {
                    ((PdfDictionary)item.values.get(n3)).put(PdfName.V, pdfName2);
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n3);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)item.widgets.get(n3);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    if (this.isInAP(pdfDictionary4, pdfName2)) {
                        pdfDictionary.put(PdfName.AS, pdfName2);
                        pdfDictionary4.put(PdfName.AS, pdfName2);
                    } else {
                        pdfDictionary.put(PdfName.AS, PdfName.OFF);
                        pdfDictionary4.put(PdfName.AS, PdfName.OFF);
                    }
                    ++n3;
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.N));
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
    }
}

