/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

public final class ArabicShaping {
    private final int options;
    private boolean isLogical;
    public static final int LENGTH_GROW_SHRINK = 0;
    public static final int LENGTH_FIXED_SPACES_NEAR = 1;
    public static final int LENGTH_FIXED_SPACES_AT_END = 2;
    public static final int LENGTH_FIXED_SPACES_AT_BEGINNING = 3;
    public static final int LENGTH_MASK = 3;
    public static final int TEXT_DIRECTION_LOGICAL = 0;
    public static final int TEXT_DIRECTION_VISUAL_LTR = 4;
    public static final int TEXT_DIRECTION_MASK = 4;
    public static final int LETTERS_NOOP = 0;
    public static final int LETTERS_SHAPE = 8;
    public static final int LETTERS_UNSHAPE = 16;
    public static final int LETTERS_SHAPE_TASHKEEL_ISOLATED = 24;
    public static final int LETTERS_MASK = 24;
    public static final int DIGITS_NOOP = 0;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    private static final int DIGITS_RESERVED = 160;
    public static final int DIGITS_MASK = 224;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    public static final int DIGIT_TYPE_MASK = 256;
    private static final int IRRELEVANT = 4;
    private static final int LAMTYPE = 16;
    private static final int ALEFTYPE = 32;
    private static final int LINKR = 1;
    private static final int LINKL = 2;
    private static final int LINK_MASK = 3;
    private static final int[] irrelevantPos = new int[]{0, 2, 4, 6, 8, 10, 12, 14};
    private static final char[] convertLamAlef = new char[]{'\u0622', '\u0622', '\u0623', '\u0623', '\u0625', '\u0625', '\u0627', '\u0627'};
    private static final char[] convertNormalizedLamAlef = new char[]{'\u0622', '\u0623', '\u0625', '\u0627'};
    private static final int[] araLink = new int[]{4385, 4897, 5377, 5921, 6403, 7457, 7939, 8961, 9475, 10499, 11523, 12547, 13571, 14593, 15105, 15617, 16129, 16643, 17667, 18691, 19715, 20739, 21763, 22787, 23811, 0, 0, 0, 0, 0, 3, 24835, 25859, 26883, 27923, 28931, 29955, 30979, 32001, 32513, 33027, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 34049, 34561, 35073, 35585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 33, 33, 0, 33, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 3, 3, 1, 1};
    private static final int[] presLink = new int[]{3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 32, 33, 32, 33, 0, 1, 32, 33, 0, 2, 3, 1, 32, 33, 0, 2, 3, 1, 0, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 16, 18, 19, 17, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1};
    private static int[] convertFEto06 = new int[]{1611, 1611, 1612, 1612, 1613, 1613, 1614, 1614, 1615, 1615, 1616, 1616, 1617, 1617, 1618, 1618, 1569, 1570, 1570, 1571, 1571, 1572, 1572, 1573, 1573, 1574, 1574, 1574, 1574, 1575, 1575, 1576, 1576, 1576, 1576, 1577, 1577, 1578, 1578, 1578, 1578, 1579, 1579, 1579, 1579, 1580, 1580, 1580, 1580, 1581, 1581, 1581, 1581, 1582, 1582, 1582, 1582, 1583, 1583, 1584, 1584, 1585, 1585, 1586, 1586, 1587, 1587, 1587, 1587, 1588, 1588, 1588, 1588, 1589, 1589, 1589, 1589, 1590, 1590, 1590, 1590, 1591, 1591, 1591, 1591, 1592, 1592, 1592, 1592, 1593, 1593, 1593, 1593, 1594, 1594, 1594, 1594, 1601, 1601, 1601, 1601, 1602, 1602, 1602, 1602, 1603, 1603, 1603, 1603, 1604, 1604, 1604, 1604, 1605, 1605, 1605, 1605, 1606, 1606, 1606, 1606, 1607, 1607, 1607, 1607, 1608, 1608, 1609, 1609, 1610, 1610, 1610, 1610, 1628, 1628, 1629, 1629, 1630, 1630, 1631, 1631};
    private static final int[][][] shapeTable = new int[][][]{new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 3}, {0, 1, 0, 1}}, new int[][]{{0, 0, 2, 2}, {0, 0, 1, 2}, {0, 1, 1, 2}, {0, 1, 1, 3}}, new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 3}, {0, 1, 0, 3}}, new int[][]{{0, 0, 1, 2}, {0, 0, 1, 2}, {0, 1, 1, 2}, {0, 1, 1, 3}}};
    static /* synthetic */ Class class$com$lowagie$text$pdf$ArabicShaping;

    public int shape(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        if (cArray == null) {
            throw new IllegalArgumentException("source can not be null");
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IllegalArgumentException("bad source start (" + n + ") or length (" + n2 + ") for buffer of length " + cArray.length);
        }
        if (cArray2 == null && n4 != 0) {
            throw new IllegalArgumentException("null dest requires destSize == 0");
        }
        if (n4 != 0 && (n3 < 0 || n4 < 0 || n3 + n4 > cArray2.length)) {
            throw new IllegalArgumentException("bad dest start (" + n3 + ") or size (" + n4 + ") for buffer of length " + cArray2.length);
        }
        return this.internalShape(cArray, n, n2, cArray2, n3, n4);
    }

    public void shape(char[] cArray, int n, int n2) {
        if ((this.options & 3) == 0) {
            throw new RuntimeException("Cannot shape in place with length option grow/shrink.");
        }
        this.shape(cArray, n, n2, cArray, n, n2);
    }

    public String shape(String string) {
        char[] cArray;
        char[] cArray2 = cArray = string.toCharArray();
        if ((this.options & 3) == 0 && (this.options & 0x18) == 16) {
            cArray2 = new char[cArray.length * 2];
        }
        int n = this.shape(cArray, 0, cArray.length, cArray2, 0, cArray2.length);
        return new String(cArray2, 0, n);
    }

    public ArabicShaping(int n) {
        this.options = n;
        if ((n & 0xE0) > 128) {
            throw new IllegalArgumentException("bad DIGITS options");
        }
        this.isLogical = (n & 4) == 0;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == (class$com$lowagie$text$pdf$ArabicShaping == null ? (class$com$lowagie$text$pdf$ArabicShaping = ArabicShaping.class$("com.lowagie.text.pdf.ArabicShaping")) : class$com$lowagie$text$pdf$ArabicShaping) && this.options == ((ArabicShaping)object).options;
    }

    public int hashCode() {
        return this.options;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('[');
        switch (this.options & 3) {
            case 0: {
                stringBuffer.append("grow/shrink");
                break;
            }
            case 1: {
                stringBuffer.append("spaces near");
                break;
            }
            case 2: {
                stringBuffer.append("spaces at end");
                break;
            }
            case 3: {
                stringBuffer.append("spaces at beginning");
            }
        }
        switch (this.options & 4) {
            case 0: {
                stringBuffer.append(", logical");
                break;
            }
            case 4: {
                stringBuffer.append(", visual");
            }
        }
        switch (this.options & 0x18) {
            case 0: {
                stringBuffer.append(", no letter shaping");
                break;
            }
            case 8: {
                stringBuffer.append(", shape letters");
                break;
            }
            case 24: {
                stringBuffer.append(", shape letters tashkeel isolated");
                break;
            }
            case 16: {
                stringBuffer.append(", unshape letters");
            }
        }
        switch (this.options & 0xE0) {
            case 0: {
                stringBuffer.append(", no digit shaping");
                break;
            }
            case 32: {
                stringBuffer.append(", shape digits to AN");
                break;
            }
            case 64: {
                stringBuffer.append(", shape digits to EN");
                break;
            }
            case 96: {
                stringBuffer.append(", shape digits to AN contextually: default EN");
                break;
            }
            case 128: {
                stringBuffer.append(", shape digits to AN contextually: default AL");
            }
        }
        switch (this.options & 0x100) {
            case 0: {
                stringBuffer.append(", standard Arabic-Indic digits");
                break;
            }
            case 256: {
                stringBuffer.append(", extended Arabic-Indic digits");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void shapeToArabicDigitsWithContext(char[] cArray, int n, int n2, char c, boolean bl) {
    }

    private static void invertBuffer(char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n + n2 - 1;
        while (n3 < n4) {
            char c = cArray[n3];
            cArray[n3] = cArray[n4];
            cArray[n4] = c;
            ++n3;
            --n4;
        }
    }

    private static char changeLamAlef(char c) {
        switch (c) {
            case '\u0622': {
                return '\u065c';
            }
            case '\u0623': {
                return '\u065d';
            }
            case '\u0625': {
                return '\u065e';
            }
            case '\u0627': {
                return '\u065f';
            }
        }
        return '\u0000';
    }

    private static int specialChar(char c) {
        if (c > '\u0621' && c < '\u0626' || c == '\u0627' || c > '\u062e' && c < '\u0633' || c > '\u0647' && c < '\u064a' || c == '\u0629') {
            return 1;
        }
        if (c >= '\u064b' && c <= '\u0652') {
            return 2;
        }
        if (c >= '\u0653' && c <= '\u0655' || c == '\u0670' || c >= '\ufe70' && c <= '\ufe7f') {
            return 3;
        }
        return 0;
    }

    private static int getLink(char c) {
        if (c >= '\u0622' && c <= '\u06d3') {
            return araLink[c - 1570];
        }
        if (c == '\u200d') {
            return 3;
        }
        if (c >= '\u206d' && c <= '\u206f') {
            return 4;
        }
        if (c >= '\ufe70' && c <= '\ufefc') {
            return presLink[c - 65136];
        }
        return 0;
    }

    private static int countSpacesLeft(char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            if (cArray[n3] != ' ') {
                return n3 - n;
            }
            ++n3;
        }
        return n2;
    }

    private static int countSpacesRight(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        while (--n3 >= n) {
            if (cArray[n3] == ' ') continue;
            return n + n2 - 1 - n3;
        }
        return n2;
    }

    private static boolean isTashkeelChar(char c) {
        return c >= '\u064b' && c <= '\u0652';
    }

    private static boolean isAlefChar(char c) {
        return c == '\u0622' || c == '\u0623' || c == '\u0625' || c == '\u0627';
    }

    private static boolean isLamAlefChar(char c) {
        return c >= '\ufef5' && c <= '\ufefc';
    }

    private static boolean isNormalizedLamAlefChar(char c) {
        return c >= '\u065c' && c <= '\u065f';
    }

    private int calculateSize(char[] cArray, int n, int n2) {
        int n3 = n2;
        switch (this.options & 0x18) {
            case 8: 
            case 24: {
                if (this.isLogical) {
                    int n4 = n;
                    int n5 = n + n2 - 1;
                    while (n4 < n5) {
                        if (cArray[n4] == '\u0644' && ArabicShaping.isAlefChar(cArray[n4 + 1])) {
                            --n3;
                        }
                        ++n4;
                    }
                } else {
                    int n6 = n + 1;
                    int n7 = n + n2;
                    while (n6 < n7) {
                        if (cArray[n6] == '\u0644' && ArabicShaping.isAlefChar(cArray[n6 - 1])) {
                            --n3;
                        }
                        ++n6;
                    }
                }
                break;
            }
            case 16: {
                int n8 = n;
                int n9 = n + n2;
                while (n8 < n9) {
                    if (ArabicShaping.isLamAlefChar(cArray[n8])) {
                        ++n3;
                    }
                    ++n8;
                }
                break;
            }
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private int removeLamAlefSpaces(char[] var1_1, int var2_2, int var3_3) {
        block14: {
            block15: {
                block13: {
                    var4_4 = this.options & 3;
                    if (!this.isLogical) {
                        switch (var4_4) {
                            case 3: {
                                var4_4 = 2;
                                break;
                            }
                            case 2: {
                                var4_4 = 3;
                                break;
                            }
                        }
                    }
                    if (var4_4 != 1) break block13;
                    var5_5 = var2_2;
                    var6_7 = var5_5 + var3_3;
                    while (var5_5 < var6_7) {
                        if (var1_1[var5_5] == '\uffff') {
                            var1_1[var5_5] = 32;
                        }
                        ++var5_5;
                    }
                    break block14;
                }
                var6_8 = var5_6 = var2_2 + var3_3;
                var7_9 = var5_6;
                while (--var7_9 >= var2_2) {
                    var8_10 = var1_1[var7_9];
                    if (var8_10 == '\uffff' || --var6_8 == var7_9) continue;
                    var1_1[var6_8] = var8_10;
                }
                if (var4_4 != 2) break block15;
                while (var6_8 > var2_2) {
                    var1_1[--var6_8] = 32;
                }
                break block14;
            }
            if (var6_8 > var2_2) {
                var7_9 = var6_8;
                var6_8 = var2_2;
                while (var7_9 < var5_6) {
                    var1_1[var6_8++] = var1_1[var7_9++];
                }
            } else {
                var6_8 = var5_6;
            }
            if (var4_4 != 0) ** GOTO lbl45
            var3_3 = var6_8 - var2_2;
            break block14;
lbl-1000:
            // 1 sources

            {
                var1_1[var6_8++] = 32;
lbl45:
                // 2 sources

                ** while (var6_8 < var5_6)
            }
        }
        return var3_3;
    }

    private int expandLamAlef(char[] cArray, int n, int n2, int n3) {
        int n4 = this.options & 3;
        if (!this.isLogical) {
            switch (n4) {
                case 3: {
                    n4 = 2;
                    break;
                }
                case 2: {
                    n4 = 3;
                    break;
                }
            }
        }
        switch (n4) {
            case 0: {
                int n5 = n + n2;
                int n6 = n5 + n3;
                while (--n5 >= n) {
                    char c = cArray[n5];
                    if (ArabicShaping.isNormalizedLamAlefChar(c)) {
                        cArray[--n6] = 1604;
                        cArray[--n6] = convertNormalizedLamAlef[c - 1628];
                        continue;
                    }
                    cArray[--n6] = c;
                }
                n2 += n3;
                break;
            }
            case 1: {
                if (ArabicShaping.isNormalizedLamAlefChar(cArray[n])) {
                    throw new RuntimeException("no space for lamalef");
                }
                int n7 = n + n2;
                while (--n7 > n) {
                    char c = cArray[n7];
                    if (!ArabicShaping.isNormalizedLamAlefChar(c)) continue;
                    if (cArray[n7 - 1] == ' ') {
                        cArray[n7] = 1604;
                        cArray[--n7] = convertNormalizedLamAlef[c - 1628];
                        continue;
                    }
                    throw new RuntimeException("no space for lamalef");
                }
                break;
            }
            case 2: {
                if (n3 > ArabicShaping.countSpacesLeft(cArray, n, n2)) {
                    throw new RuntimeException("no space for lamalef");
                }
                int n8 = n + n3;
                int n9 = n;
                int n10 = n + n2;
                while (n8 < n10) {
                    char c = cArray[n8];
                    if (ArabicShaping.isNormalizedLamAlefChar(c)) {
                        cArray[n9++] = convertNormalizedLamAlef[c - 1628];
                        cArray[n9++] = 1604;
                    } else {
                        cArray[n9++] = c;
                    }
                    ++n8;
                }
                break;
            }
            case 3: {
                if (n3 > ArabicShaping.countSpacesRight(cArray, n, n2)) {
                    throw new RuntimeException("no space for lamalef");
                }
                int n11 = n + n2 - n3;
                int n12 = n + n2;
                while (--n11 >= n) {
                    char c = cArray[n11];
                    if (ArabicShaping.isNormalizedLamAlefChar(c)) {
                        cArray[--n12] = 1604;
                        cArray[--n12] = convertNormalizedLamAlef[c - 1628];
                        continue;
                    }
                    cArray[--n12] = c;
                }
                break;
            }
        }
        return n2;
    }

    private int normalize(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = n4 + n2;
        while (n4 < n5) {
            char c = cArray[n4];
            if (c >= '\ufe70' && c <= '\ufefc') {
                if (ArabicShaping.isLamAlefChar(c)) {
                    ++n3;
                }
                cArray[n4] = (char)convertFEto06[c - 65136];
            }
            ++n4;
        }
        return n3;
    }

    private int shapeUnicode(char[] cArray, int n, int n2, int n3, int n4) {
        this.normalize(cArray, n, n2);
        boolean bl = false;
        int n5 = n + n2 - 1;
        int n6 = ArabicShaping.getLink(cArray[n5]);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = n5;
        int n11 = n5;
        int n12 = -2;
        int n13 = 0;
        while (n5 >= 0) {
            if ((n6 & 0xFF00) > 0 || ArabicShaping.isTashkeelChar(cArray[n5])) {
                char c;
                n13 = n5 - 1;
                n12 = -2;
                while (n12 < 0) {
                    if (n13 == -1) {
                        n7 = 0;
                        n12 = Integer.MAX_VALUE;
                        continue;
                    }
                    n7 = ArabicShaping.getLink(cArray[n13]);
                    if ((n7 & 4) == 0) {
                        n12 = n13;
                        continue;
                    }
                    --n13;
                }
                if ((n6 & 0x20) > 0 && (n9 & 0x10) > 0) {
                    bl = true;
                    c = ArabicShaping.changeLamAlef(cArray[n5]);
                    if (c != '\u0000') {
                        cArray[n5] = 65535;
                        cArray[n11] = c;
                        n5 = n11;
                    }
                    n9 = n8;
                    n6 = ArabicShaping.getLink(c);
                }
                c = ArabicShaping.specialChar(cArray[n5]);
                int n14 = shapeTable[n7 & 3][n9 & 3][n6 & 3];
                if (c == '\u0001') {
                    n14 &= 1;
                } else if (c == '\u0002') {
                    n14 = n4 == 0 && (n9 & 2) != 0 && (n7 & 1) != 0 && cArray[n5] != '\u064c' && cArray[n5] != '\u064d' && ((n7 & 0x20) != 32 || (n9 & 0x10) != 16) ? 1 : 0;
                }
                if (c == '\u0002') {
                    if (n4 < 2) {
                        cArray[n5] = (char)(65136 + irrelevantPos[cArray[n5] - 1611] + n14);
                    }
                } else {
                    cArray[n5] = (char)(65136 + (n6 >> 8) + n14);
                }
            }
            if ((n6 & 4) == 0) {
                n8 = n9;
                n9 = n6;
                n10 = n11;
                n11 = n5;
            }
            if (--n5 == n12) {
                n6 = n7;
                n12 = -2;
                continue;
            }
            if (n5 == -1) continue;
            n6 = ArabicShaping.getLink(cArray[n5]);
        }
        n3 = bl ? this.removeLamAlefSpaces(cArray, n, n2) : n2;
        return n3;
    }

    private int deShapeUnicode(char[] cArray, int n, int n2, int n3) {
        int n4 = this.normalize(cArray, n, n2);
        n3 = n4 != 0 ? this.expandLamAlef(cArray, n, n2, n4) : n2;
        return n3;
    }

    private int internalShape(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        if (n2 == 0) {
            return 0;
        }
        if (n4 == 0) {
            if ((this.options & 0x18) != 0 && (this.options & 3) == 0) {
                return this.calculateSize(cArray, n, n2);
            }
            return n2;
        }
        char[] cArray3 = new char[n2 * 2];
        System.arraycopy(cArray, n, cArray3, 0, n2);
        if (this.isLogical) {
            ArabicShaping.invertBuffer(cArray3, 0, n2);
        }
        int n5 = n2;
        switch (this.options & 0x18) {
            case 24: {
                n5 = this.shapeUnicode(cArray3, 0, n2, n4, 1);
                break;
            }
            case 8: {
                n5 = this.shapeUnicode(cArray3, 0, n2, n4, 0);
                break;
            }
            case 16: {
                n5 = this.deShapeUnicode(cArray3, 0, n2, n4);
                break;
            }
        }
        if (n5 > n4) {
            throw new RuntimeException("not enough room for result data");
        }
        if ((this.options & 0xE0) != 0) {
            char c = '0';
            switch (this.options & 0x100) {
                case 0: {
                    c = '\u0660';
                    break;
                }
                case 256: {
                    c = '\u06f0';
                    break;
                }
            }
            switch (this.options & 0xE0) {
                case 32: {
                    int n6 = c - 48;
                    int n7 = 0;
                    while (n7 < n5) {
                        char c2 = cArray3[n7];
                        if (c2 <= '9' && c2 >= '0') {
                            int n8 = n7;
                            cArray3[n8] = (char)(cArray3[n8] + n6);
                        }
                        ++n7;
                    }
                    break;
                }
                case 64: {
                    char c3 = (char)(c + 9);
                    int n9 = 48 - c;
                    int n10 = 0;
                    while (n10 < n5) {
                        char c4 = cArray3[n10];
                        if (c4 <= c3 && c4 >= c) {
                            int n11 = n10;
                            cArray3[n11] = (char)(cArray3[n11] + n9);
                        }
                        ++n10;
                    }
                    break;
                }
                case 96: {
                    this.shapeToArabicDigitsWithContext(cArray3, 0, n5, c, false);
                    break;
                }
                case 128: {
                    this.shapeToArabicDigitsWithContext(cArray3, 0, n5, c, true);
                    break;
                }
            }
        }
        if (this.isLogical) {
            ArabicShaping.invertBuffer(cArray3, 0, n5);
        }
        System.arraycopy(cArray3, 0, cArray2, n3, n5);
        return n5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

