/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfColorDictionary;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFontDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPatternDictionary;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfShadingDictionary;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import java.util.HashMap;
import java.util.Iterator;

class PageResources {
    protected PdfFontDictionary fontDictionary = new PdfFontDictionary();
    protected PdfXObjectDictionary xObjectDictionary = new PdfXObjectDictionary();
    protected PdfColorDictionary colorDictionary = new PdfColorDictionary();
    protected PdfPatternDictionary patternDictionary = new PdfPatternDictionary();
    protected PdfShadingDictionary shadingDictionary = new PdfShadingDictionary();
    protected HashMap forbiddenNames;
    protected PdfDictionary originalResources;
    protected int namePtr = 0;
    protected HashMap usedNames;

    PageResources() {
    }

    void setOriginalResources(PdfDictionary pdfDictionary, PdfReader pdfReader) {
        this.originalResources = pdfDictionary;
        this.forbiddenNames = new HashMap();
        this.usedNames = new HashMap();
        if (pdfDictionary == null) {
            return;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get((PdfName)iterator.next()));
            if (pdfObject.type() != 6) continue;
            PdfDictionary pdfDictionary2 = (PdfDictionary)pdfObject;
            Iterator iterator2 = pdfDictionary2.getKeys().iterator();
            while (iterator2.hasNext()) {
                this.forbiddenNames.put(iterator2.next(), null);
            }
        }
    }

    PdfName translateName(PdfName pdfName) {
        PdfName pdfName2 = pdfName;
        if (this.forbiddenNames != null && (pdfName2 = (PdfName)this.usedNames.get(pdfName)) == null) {
            while (this.forbiddenNames.containsKey(pdfName2 = new PdfName("Xi" + this.namePtr++))) {
            }
            this.usedNames.put(pdfName, pdfName2);
        }
        return pdfName2;
    }

    PdfName addFont(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.fontDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addXObject(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.xObjectDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addColor(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.colorDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addShading(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.shadingDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addPattern(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.patternDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfResources getResources() {
        PdfResources pdfResources = new PdfResources();
        if (this.originalResources != null) {
            pdfResources.putAll(this.originalResources);
        }
        pdfResources.put(PdfName.PROCSET, new PdfLiteral("[/PDF /Text /ImageB /ImageC /ImageI]"));
        if (this.fontDictionary.containsFont()) {
            pdfResources.add(this.fontDictionary);
        }
        if (this.xObjectDictionary.containsXObject()) {
            pdfResources.add(this.xObjectDictionary);
        }
        if (this.colorDictionary.containsColorSpace()) {
            pdfResources.add(this.colorDictionary);
        }
        if (this.patternDictionary.containsPattern()) {
            pdfResources.add(this.patternDictionary);
        }
        if (this.shadingDictionary.containsShading()) {
            pdfResources.add(this.shadingDictionary);
        }
        return pdfResources;
    }
}

