/*
 * Decompiled with CFR 0.152.
 */
package xmlwise;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import xmlwise.XmlElement;
import xmlwise.XmlParseException;
import xmlwise.Xmlwise;

public final class Plist {
    private static final Plist PLIST = new Plist();
    private static final String BASE64_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private final DateFormat m_dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Map<Class, ElementType> m_simpleTypes;

    public static String toXml(Map<String, Object> map) {
        return Plist.toPlist(map);
    }

    public static String toPlist(Object object) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">");
        stringBuilder.append(PLIST.objectToXml(object).toXml());
        return stringBuilder.append("</plist>").toString();
    }

    public static void store(Map<String, Object> map, String string) throws IOException {
        Plist.store(map, new File(string));
    }

    public static void storeObject(Object object, String string) throws IOException {
        Plist.storeObject(object, new File(string));
    }

    public static void store(Map<String, Object> map, File file) throws IOException {
        Plist.storeObject(map, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeObject(Object object, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(Plist.toPlist(object).getBytes());
        }
        catch (Throwable throwable) {
            Plist.silentlyClose(fileOutputStream);
            throw throwable;
        }
        Plist.silentlyClose(fileOutputStream);
    }

    static void silentlyClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Map<String, Object> fromXml(String string) throws XmlParseException {
        return Plist.fromXmlElement(Xmlwise.createXml(string));
    }

    public static Map<String, Object> fromXmlElement(XmlElement xmlElement) throws XmlParseException {
        return PLIST.parse(xmlElement);
    }

    public static Object objectFromXmlElement(XmlElement xmlElement) throws XmlParseException {
        return PLIST.parseObject(xmlElement);
    }

    public static Object objectFromXml(String string) throws XmlParseException {
        return Plist.objectFromXmlElement(Xmlwise.createXml(string));
    }

    public static Map<String, Object> load(File file) throws XmlParseException, IOException {
        return Plist.fromXmlElement(Xmlwise.loadXml(file));
    }

    public static Object loadObject(File file) throws XmlParseException, IOException {
        return Plist.objectFromXmlElement(Xmlwise.loadXml(file));
    }

    public static Map<String, Object> load(String string) throws XmlParseException, IOException {
        return Plist.load(new File(string));
    }

    public static Object loadObject(String string) throws XmlParseException, IOException {
        return Plist.loadObject(new File(string));
    }

    Plist() {
        this.m_dateFormat.setTimeZone(TimeZone.getTimeZone("Z"));
        this.m_simpleTypes = new HashMap<Class, ElementType>();
        this.m_simpleTypes.put(Integer.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Byte.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Short.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Short.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Long.class, ElementType.INTEGER);
        this.m_simpleTypes.put(String.class, ElementType.STRING);
        this.m_simpleTypes.put(Float.class, ElementType.REAL);
        this.m_simpleTypes.put(Double.class, ElementType.REAL);
        this.m_simpleTypes.put(byte[].class, ElementType.DATA);
        this.m_simpleTypes.put(Boolean.class, ElementType.TRUE);
        this.m_simpleTypes.put(Date.class, ElementType.DATE);
    }

    XmlElement objectToXml(Object object) {
        ElementType elementType = this.m_simpleTypes.get(object.getClass());
        if (elementType != null) {
            switch (elementType) {
                case REAL: {
                    return new XmlElement("real", object.toString());
                }
                case INTEGER: {
                    return new XmlElement("integer", object.toString());
                }
                case TRUE: {
                    return new XmlElement((Boolean)object != false ? "true" : "false");
                }
                case DATE: {
                    return new XmlElement("date", this.m_dateFormat.format((Date)object));
                }
                case STRING: {
                    return new XmlElement("string", (String)object);
                }
                case DATA: {
                    return new XmlElement("data", Plist.base64encode((byte[])object));
                }
            }
        }
        if (object instanceof Map) {
            return this.toXmlDict((Map)object);
        }
        if (object instanceof List) {
            return this.toXmlArray((List)object);
        }
        throw new RuntimeException("Cannot use " + object.getClass() + " in plist.");
    }

    private XmlElement toXmlArray(List list) {
        XmlElement xmlElement = new XmlElement("array");
        for (Object e : list) {
            xmlElement.add(this.objectToXml(e));
        }
        return xmlElement;
    }

    private XmlElement toXmlDict(Map<String, Object> map) {
        XmlElement xmlElement = new XmlElement("dict");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            xmlElement.add(new XmlElement("key", entry.getKey()));
            xmlElement.add(this.objectToXml(entry.getValue()));
        }
        return xmlElement;
    }

    Object parseObject(XmlElement xmlElement) throws XmlParseException {
        if (!"plist".equalsIgnoreCase(xmlElement.getName())) {
            throw new XmlParseException("Expected plist top element, was: " + xmlElement.getName());
        }
        if (xmlElement.size() != 1) {
            throw new XmlParseException("Expected single child element.");
        }
        return this.parseElement((XmlElement)xmlElement.getFirst());
    }

    Map<String, Object> parse(XmlElement xmlElement) throws XmlParseException {
        if (!"plist".equalsIgnoreCase(xmlElement.getName())) {
            throw new XmlParseException("Expected plist top element, was: " + xmlElement.getName());
        }
        if (xmlElement.size() != 1) {
            throw new XmlParseException("Expected single 'dict' child element.");
        }
        xmlElement.getUnique("dict");
        return (Map)this.parseElement(xmlElement.getUnique("dict"));
    }

    private Object parseElement(XmlElement xmlElement) throws XmlParseException {
        try {
            return this.parseElementRaw(xmlElement);
        }
        catch (Exception exception) {
            throw new XmlParseException("Failed to parse: " + xmlElement.toXml(), exception);
        }
    }

    private Object parseElementRaw(XmlElement xmlElement) throws Exception {
        ElementType elementType = ElementType.valueOf(xmlElement.getName().toUpperCase());
        switch (elementType) {
            case INTEGER: {
                return this.parseInt(xmlElement.getValue());
            }
            case REAL: {
                return Double.valueOf(xmlElement.getValue());
            }
            case STRING: {
                return xmlElement.getValue();
            }
            case DATE: {
                return this.m_dateFormat.parse(xmlElement.getValue());
            }
            case DATA: {
                return Plist.base64decode(xmlElement.getValue());
            }
            case ARRAY: {
                return this.parseArray(xmlElement);
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case DICT: {
                return this.parseDict(xmlElement);
            }
        }
        throw new RuntimeException("Unexpected type: " + xmlElement.getName());
    }

    private Number parseInt(String string) {
        Long l = Long.valueOf(string);
        if ((long)l.intValue() == l) {
            return l.intValue();
        }
        return l;
    }

    private Map<String, Object> parseDict(List<XmlElement> list) throws Exception {
        Iterator<XmlElement> iterator = list.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            XmlElement xmlElement = iterator.next();
            if (!"key".equals(xmlElement.getName())) {
                throw new Exception("Expected key but was " + xmlElement.getName());
            }
            Object object = this.parseElementRaw(iterator.next());
            hashMap.put(xmlElement.getValue(), object);
        }
        return hashMap;
    }

    private List<Object> parseArray(List<XmlElement> list) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (XmlElement xmlElement : list) {
            arrayList.add(this.parseElementRaw(xmlElement));
        }
        return arrayList;
    }

    static String base64encode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder((byArray.length + 2) / 3 * 4);
        for (int i = 0; i < byArray.length; i += 3) {
            byte by = byArray[i];
            byte by2 = i < byArray.length - 1 ? byArray[i + 1] : (byte)0;
            byte by3 = i < byArray.length - 2 ? byArray[i + 2] : (byte)0;
            stringBuilder.append(BASE64_CHARS[(by & 0xFF) >> 2]);
            stringBuilder.append(BASE64_CHARS[(by & 3) << 4 | (by2 & 0xF0) >> 4]);
            stringBuilder.append(i < byArray.length - 1 ? Character.valueOf(BASE64_CHARS[(by2 & 0xF) << 2 | (by3 & 0xC0) >> 6]) : "=");
            stringBuilder.append(i < byArray.length - 2 ? Character.valueOf(BASE64_CHARS[by3 & 0x3F]) : "=");
        }
        return stringBuilder.toString();
    }

    static byte[] base64decode(String string) {
        string = string.replaceAll("\\s", "");
        int n = 0;
        if (string.endsWith("==")) {
            n = 2;
            string = string.substring(0, string.length() - 2) + "AA";
        } else if (string.endsWith("=")) {
            n = 1;
            string = string.substring(0, string.length() - 1) + "A";
        }
        if (string.length() % 4 != 0) {
            throw new IllegalArgumentException("Illegal base64 string, length " + string.length());
        }
        int n2 = string.length() / 4 * 3 - n;
        string = string.replace('=', 'A');
        byte[] byArray = new byte[n2];
        int n3 = string.length();
        int n4 = 0;
        for (int i = 0; i < n3; i += 4) {
            int n5 = BASE64_STRING.indexOf(string.charAt(i));
            int n6 = BASE64_STRING.indexOf(string.charAt(i + 1));
            int n7 = BASE64_STRING.indexOf(string.charAt(i + 2));
            int n8 = BASE64_STRING.indexOf(string.charAt(i + 3));
            byte by = (byte)(n5 << 2 | n6 >> 4);
            byte by2 = (byte)(n6 << 4 | n7 >> 2);
            byte by3 = (byte)(n7 << 6 | n8);
            byArray[n4++] = by;
            if (n4 >= n2) continue;
            byArray[n4++] = by2;
            if (n4 >= n2) continue;
            byArray[n4++] = by3;
        }
        return byArray;
    }

    private static enum ElementType {
        INTEGER,
        STRING,
        REAL,
        DATA,
        DATE,
        DICT,
        ARRAY,
        TRUE,
        FALSE;

    }
}

