/*
 * Decompiled with CFR 0.152.
 */
package xmlwise;

import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlwise.XmlElementAttributes;
import xmlwise.XmlParseException;
import xmlwise.Xmlwise;

public class XmlElement
extends LinkedList<XmlElement> {
    private final XmlElementAttributes m_attributes;
    private final String m_value;
    private final String m_name;

    public XmlElement(Element element) {
        this.m_attributes = new XmlElementAttributes(element);
        NodeList nodeList = element.getChildNodes();
        this.m_name = element.getNodeName();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                this.add(new XmlElement((Element)node));
            }
            if (node.getNodeType() != 3) continue;
            stringBuilder.append(node.getNodeValue());
        }
        this.m_value = stringBuilder.toString();
    }

    public XmlElement(String string, String string2) {
        this.m_attributes = new XmlElementAttributes();
        this.m_name = string;
        this.m_value = string2;
    }

    public XmlElement(String string) {
        this.m_attributes = new XmlElementAttributes();
        this.m_name = string;
        this.m_value = "";
    }

    public XmlElement getUnique(String string) throws XmlParseException {
        LinkedList<XmlElement> linkedList = this.get(string);
        if (linkedList.size() != 1) {
            throw new XmlParseException("Unexpected number of elements of type " + string + " in element <" + this.getName() + ">");
        }
        return linkedList.getFirst();
    }

    public int getIntAttribute(String string) throws XmlParseException {
        return this.getAttributes().getInt(string);
    }

    public int getIntAttribute(String string, int n) throws XmlParseException {
        return this.containsAttribute(string) ? this.getIntAttribute(string) : n;
    }

    public double getDoubleAttribute(String string) throws XmlParseException {
        return this.getAttributes().getDouble(string);
    }

    public double getDoubleAttribute(String string, double d) throws XmlParseException {
        return this.containsAttribute(string) ? this.getDoubleAttribute(string) : d;
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.getAttribute(string);
        return string3 == null ? string2 : string3;
    }

    public String getAttribute(String string) {
        return (String)this.getAttributes().get(string);
    }

    public boolean getBoolAttribute(String string) throws XmlParseException {
        return this.getAttributes().getBoolean(string);
    }

    public boolean getBoolAttribute(String string, boolean bl) throws XmlParseException {
        return this.containsAttribute(string) ? this.getBoolAttribute(string) : bl;
    }

    public LinkedList<XmlElement> get(String string) {
        LinkedList<XmlElement> linkedList = new LinkedList<XmlElement>();
        for (XmlElement xmlElement : this) {
            if (!xmlElement.getName().equals(string)) continue;
            linkedList.add(xmlElement);
        }
        return linkedList;
    }

    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object.toString());
    }

    public boolean removeAttribute(String string) {
        return this.m_attributes.remove(string) != null;
    }

    public boolean contains(String string) {
        for (XmlElement xmlElement : this) {
            if (!xmlElement.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder("<").append(this.m_name);
        if (this.m_attributes.size() > 0) {
            stringBuilder.append(this.m_attributes.toXml());
        }
        if (this.isEmpty() && this.m_value.length() == 0) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append('>');
            stringBuilder.append(Xmlwise.escapeXML(this.m_value));
            for (XmlElement xmlElement : this) {
                stringBuilder.append(xmlElement.toXml());
            }
            stringBuilder.append("</").append(this.m_name).append('>');
        }
        return stringBuilder.toString();
    }

    public String getValue() {
        return this.m_value;
    }

    public XmlElementAttributes getAttributes() {
        return this.m_attributes;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean containsAttribute(String string) {
        return this.getAttributes().containsKey(string);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XmlElement xmlElement = (XmlElement)object;
        if (this.m_attributes != null ? !this.m_attributes.equals(xmlElement.m_attributes) : xmlElement.m_attributes != null) {
            return false;
        }
        if (this.m_name != null ? !this.m_name.equals(xmlElement.m_name) : xmlElement.m_name != null) {
            return false;
        }
        return !(this.m_value != null ? !this.m_value.equals(xmlElement.m_value) : xmlElement.m_value != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.m_attributes != null ? this.m_attributes.hashCode() : 0);
        n = 31 * n + (this.m_value != null ? this.m_value.hashCode() : 0);
        n = 31 * n + (this.m_name != null ? this.m_name.hashCode() : 0);
        return n;
    }

    @Override
    public String toString() {
        return "[" + this.m_name + " = " + this.m_value + "; " + this.m_attributes + "; " + super.toString() + "]";
    }
}

