/*
 * Decompiled with CFR 0.152.
 */
package xmlwise;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import xmlwise.XmlParseException;
import xmlwise.Xmlwise;

public class XmlElementAttributes
extends HashMap<String, String> {
    XmlElementAttributes() {
    }

    public XmlElementAttributes(Element element) {
        super(element.getAttributes().getLength());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            this.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
        }
    }

    public int getInt(String string) throws XmlParseException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new XmlParseException("Could not find attribute " + string);
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlParseException("Failed to parse int attribute " + string, numberFormatException);
        }
    }

    public double getDouble(String string) throws XmlParseException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new XmlParseException("Could not find attribute " + string);
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlParseException("Failed to parse double attribute " + string, numberFormatException);
        }
    }

    public boolean getBoolean(String string) throws XmlParseException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new XmlParseException("Could not find attribute " + string);
        }
        if ("true".equals(string2 = string2.toLowerCase()) || "yes".equals(string2) || "y".equals(string2)) {
            return true;
        }
        if ("false".equals(string2) || "no".equals(string2) || "n".equals(string2)) {
            return false;
        }
        throw new XmlParseException("Attribute " + string + " did not have boolean value (was: " + string2 + ')');
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder(10 * this.size());
        for (Map.Entry entry : this.entrySet()) {
            stringBuilder.append(' ').append((String)entry.getKey()).append("=").append("'");
            stringBuilder.append(Xmlwise.escapeXML((String)entry.getValue())).append("'");
        }
        return stringBuilder.toString();
    }
}

