/*
 * Decompiled with CFR 0.152.
 */
package xmlwise;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import xmlwise.XmlElement;
import xmlwise.XmlParseException;

public class Xmlwise {
    private Xmlwise() {
    }

    public static Document loadDocument(File file) throws IOException, XmlParseException {
        return Xmlwise.loadDocument(file, false, false);
    }

    public static Document loadDocument(File file, boolean bl, boolean bl2) throws IOException, XmlParseException {
        try {
            return Xmlwise.getBuilderFactory(bl, bl2).parse(file);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new XmlParseException(exception);
        }
    }

    private static DocumentBuilder getBuilderFactory(boolean bl, boolean bl2) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        documentBuilderFactory.setValidating(bl);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document createDocument(String string, boolean bl, boolean bl2) throws XmlParseException {
        try {
            return Xmlwise.getBuilderFactory(bl, bl2).parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            throw new XmlParseException(exception);
        }
    }

    public static Document createDocument(String string) throws XmlParseException {
        return Xmlwise.createDocument(string, false, false);
    }

    public static String escapeXML(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static XmlElement loadXml(File file) throws XmlParseException, IOException {
        return new XmlElement(Xmlwise.loadDocument(file).getDocumentElement());
    }

    public static XmlElement loadXml(String string) throws XmlParseException, IOException {
        return Xmlwise.loadXml(new File(string));
    }

    public static XmlElement createXml(String string) throws XmlParseException {
        return new XmlElement(Xmlwise.createDocument(string).getDocumentElement());
    }
}

