/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateScalingTriggerRequest;
import com.amazonaws.services.autoscaling.model.Dimension;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrUpdateScalingTriggerRequestMarshaller
implements Marshaller<Request<CreateOrUpdateScalingTriggerRequest>, CreateOrUpdateScalingTriggerRequest> {
    @Override
    public Request<CreateOrUpdateScalingTriggerRequest> marshall(CreateOrUpdateScalingTriggerRequest createOrUpdateScalingTriggerRequest) {
        DefaultRequest<CreateOrUpdateScalingTriggerRequest> request = new DefaultRequest<CreateOrUpdateScalingTriggerRequest>(createOrUpdateScalingTriggerRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateOrUpdateScalingTrigger");
        request.addParameter("Version", "2009-05-15");
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getTriggerName() != null) {
            request.addParameter("TriggerName", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getTriggerName()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getAutoScalingGroupName()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getMeasureName() != null) {
            request.addParameter("MeasureName", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getMeasureName()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getStatistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getStatistic()));
        }
        if (createOrUpdateScalingTriggerRequest != null) {
            List<Dimension> dimensionsList = createOrUpdateScalingTriggerRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null && dimensionsListValue.getName() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                }
                if (dimensionsListValue != null && dimensionsListValue.getValue() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                }
                ++dimensionsListIndex;
            }
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger(createOrUpdateScalingTriggerRequest.getPeriod()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getUnit()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getCustomUnit() != null) {
            request.addParameter("CustomUnit", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getCustomUnit()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getNamespace()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getLowerThreshold() != null) {
            request.addParameter("LowerThreshold", StringUtils.fromDouble(createOrUpdateScalingTriggerRequest.getLowerThreshold()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getLowerBreachScaleIncrement() != null) {
            request.addParameter("LowerBreachScaleIncrement", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getLowerBreachScaleIncrement()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getUpperThreshold() != null) {
            request.addParameter("UpperThreshold", StringUtils.fromDouble(createOrUpdateScalingTriggerRequest.getUpperThreshold()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getUpperBreachScaleIncrement() != null) {
            request.addParameter("UpperBreachScaleIncrement", StringUtils.fromString(createOrUpdateScalingTriggerRequest.getUpperBreachScaleIncrement()));
        }
        if (createOrUpdateScalingTriggerRequest != null && createOrUpdateScalingTriggerRequest.getBreachDuration() != null) {
            request.addParameter("BreachDuration", StringUtils.fromInteger(createOrUpdateScalingTriggerRequest.getBreachDuration()));
        }
        return request;
    }
}

