/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJobFlowStepsRequestMarshaller
implements Marshaller<Request<AddJobFlowStepsRequest>, AddJobFlowStepsRequest> {
    @Override
    public Request<AddJobFlowStepsRequest> marshall(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        DefaultRequest<AddJobFlowStepsRequest> request = new DefaultRequest<AddJobFlowStepsRequest>(addJobFlowStepsRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "AddJobFlowSteps");
        request.addParameter("Version", "2009-03-31");
        if (addJobFlowStepsRequest != null && addJobFlowStepsRequest.getJobFlowId() != null) {
            request.addParameter("JobFlowId", StringUtils.fromString(addJobFlowStepsRequest.getJobFlowId()));
        }
        if (addJobFlowStepsRequest != null) {
            List<StepConfig> stepsList = addJobFlowStepsRequest.getSteps();
            int stepsListIndex = 1;
            for (StepConfig stepsListValue : stepsList) {
                if (stepsListValue != null && stepsListValue.getName() != null) {
                    request.addParameter("Steps.member." + stepsListIndex + ".Name", StringUtils.fromString(stepsListValue.getName()));
                }
                if (stepsListValue != null && stepsListValue.getActionOnFailure() != null) {
                    request.addParameter("Steps.member." + stepsListIndex + ".ActionOnFailure", StringUtils.fromString(stepsListValue.getActionOnFailure()));
                }
                if (stepsListValue != null) {
                    HadoopJarStepConfig hadoopJarStep = stepsListValue.getHadoopJarStep();
                    if (hadoopJarStep != null) {
                        List<KeyValue> propertiesList = hadoopJarStep.getProperties();
                        int propertiesListIndex = 1;
                        for (KeyValue propertiesListValue : propertiesList) {
                            if (propertiesListValue != null && propertiesListValue.getKey() != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Properties.member." + propertiesListIndex + ".Key", StringUtils.fromString(propertiesListValue.getKey()));
                            }
                            if (propertiesListValue != null && propertiesListValue.getValue() != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Properties.member." + propertiesListIndex + ".Value", StringUtils.fromString(propertiesListValue.getValue()));
                            }
                            ++propertiesListIndex;
                        }
                    }
                    if (hadoopJarStep != null && hadoopJarStep.getJar() != null) {
                        request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Jar", StringUtils.fromString(hadoopJarStep.getJar()));
                    }
                    if (hadoopJarStep != null && hadoopJarStep.getMainClass() != null) {
                        request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.MainClass", StringUtils.fromString(hadoopJarStep.getMainClass()));
                    }
                    if (hadoopJarStep != null) {
                        List<String> argsList = hadoopJarStep.getArgs();
                        int argsListIndex = 1;
                        for (String argsListValue : argsList) {
                            if (argsListValue != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Args.member." + argsListIndex, StringUtils.fromString(argsListValue));
                            }
                            ++argsListIndex;
                        }
                    }
                }
                ++stepsListIndex;
            }
        }
        return request;
    }
}

