/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.services.s3.internal.RestUtils;
import java.security.SignatureException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3QueryStringSigner<T>
extends AbstractAWSSigner {
    private final AWSCredentials credentials;
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public S3QueryStringSigner(AWSCredentials credentials, String httpVerb, String resourcePath, Date expiration) {
        this.credentials = credentials;
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        this.expiration = expiration;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(Request<T> request) throws SignatureException {
        String accessKeyId;
        String secretKey;
        String expirationInSeconds = Long.toString(this.expiration.getTime() / 1000L);
        String canonicalString = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, request, expirationInSeconds);
        AWSCredentials aWSCredentials = this.credentials;
        synchronized (aWSCredentials) {
            secretKey = this.credentials.getAWSSecretKey();
            accessKeyId = this.credentials.getAWSAccessKeyId();
        }
        String signature = super.sign(canonicalString, secretKey, SigningAlgorithm.HmacSHA1);
        request.addParameter("AWSAccessKeyId", accessKeyId);
        request.addParameter("Expires", expirationInSeconds);
        request.addParameter("Signature", signature);
    }
}

