/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ReconnectPolicy;
import com.notnoop.apns.internal.AbstractApnsService;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ApnsConnectionImpl;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.ApnsPooledConnection;
import com.notnoop.apns.internal.ApnsServiceImpl;
import com.notnoop.apns.internal.MinaAdaptor;
import com.notnoop.apns.internal.QueuedApnsService;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.InvalidSSLConfig;
import com.notnoop.exceptions.RuntimeIOException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class ApnsServiceBuilder {
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String KEY_ALGORITHM = "sunx509";
    private SSLContext sslContext = null;
    private String gatewayHost;
    private int gatewaPort = -1;
    private String feedbackHost;
    private int feedbackPort;
    private int pooledMax = 1;
    private ReconnectPolicy reconnectPolicy = ReconnectPolicy.Provided.NEVER.newObject();
    private boolean isQueued = false;
    private boolean isNonBlocking = false;
    private ApnsDelegate delegate = ApnsDelegate.EMPTY;
    private Socket proxySocket = null;
    private boolean errorDetection = true;

    public ApnsServiceBuilder withCert(String fileName, String password) throws RuntimeIOException, InvalidSSLConfig {
        ApnsServiceBuilder apnsServiceBuilder;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fileName);
            apnsServiceBuilder = this.withCert(stream, password);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                Utilities.close(stream);
                throw throwable;
            }
        }
        Utilities.close(stream);
        return apnsServiceBuilder;
    }

    public ApnsServiceBuilder withCert(InputStream stream, String password) throws InvalidSSLConfig {
        return this.withSSLContext(Utilities.newSSLContext(stream, password, KEYSTORE_TYPE, KEY_ALGORITHM));
    }

    public ApnsServiceBuilder withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ApnsServiceBuilder withGatewayDestination(String host, int port) {
        this.gatewayHost = host;
        this.gatewaPort = port;
        return this;
    }

    public ApnsServiceBuilder withFeedbackDestination(String host, int port) {
        this.feedbackHost = host;
        this.feedbackPort = port;
        return this;
    }

    public ApnsServiceBuilder withSandboxDestination() {
        return this.withGatewayDestination("gateway.sandbox.push.apple.com", 2195).withFeedbackDestination("feedback.sandbox.push.apple.com", 2196);
    }

    public ApnsServiceBuilder withProductionDestination() {
        return this.withGatewayDestination("gateway.push.apple.com", 2195).withFeedbackDestination("feedback.push.apple.com", 2196);
    }

    public ApnsServiceBuilder withReconnectPolicy(ReconnectPolicy rp) {
        this.reconnectPolicy = rp;
        return this;
    }

    public ApnsServiceBuilder withReconnectPolicy(ReconnectPolicy.Provided rp) {
        this.reconnectPolicy = rp.newObject();
        return this;
    }

    public ApnsServiceBuilder withSocksProxy(String host, int port) {
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
        return this.withProxy(proxy);
    }

    public ApnsServiceBuilder withProxy(Proxy proxy) {
        return this.withProxySocket(new Socket(proxy));
    }

    public ApnsServiceBuilder withProxySocket(Socket proxySocket) {
        this.proxySocket = proxySocket;
        return this;
    }

    public ApnsServiceBuilder asPool(int maxConnections) {
        this.pooledMax = maxConnections;
        return this;
    }

    public ApnsServiceBuilder asQueued() {
        this.isQueued = true;
        return this;
    }

    public ApnsServiceBuilder asNonBlocking() {
        this.isNonBlocking = true;
        return this;
    }

    public ApnsServiceBuilder withDelegate(ApnsDelegate delegate) {
        this.delegate = delegate == null ? ApnsDelegate.EMPTY : delegate;
        return this;
    }

    public ApnsServiceBuilder withNoErrorDetection() {
        this.errorDetection = true;
        return this;
    }

    public ApnsService build() {
        AbstractApnsService service;
        this.checkInitialization();
        SSLSocketFactory sslFactory = this.sslContext.getSocketFactory();
        ApnsFeedbackConnection feedback = new ApnsFeedbackConnection(sslFactory, this.feedbackHost, this.feedbackPort);
        if (this.isNonBlocking) {
            service = new MinaAdaptor(this.sslContext, this.gatewayHost, this.gatewaPort, feedback);
        } else {
            ApnsConnection conn = new ApnsConnectionImpl(sslFactory, this.gatewayHost, this.gatewaPort, this.proxySocket, this.reconnectPolicy, this.delegate, this.errorDetection);
            if (this.pooledMax != 1) {
                conn = new ApnsPooledConnection(conn, this.pooledMax);
            }
            service = new ApnsServiceImpl(conn, feedback);
            if (this.isQueued) {
                service = new QueuedApnsService(service);
            }
        }
        service.start();
        return service;
    }

    private void checkInitialization() {
        if (this.sslContext == null) {
            throw new IllegalStateException("SSL Certificates and attribute are not initialized\nUse .withCert() methods.");
        }
        if (this.gatewayHost == null || this.gatewaPort == -1) {
            throw new IllegalStateException("The Destination APNS server is not stated\nUse .withDestination(), withSandboxDestination(), or withProductionDestination().");
        }
    }
}

