/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractApnsService
implements ApnsService {
    private ApnsFeedbackConnection feedback;
    private AtomicInteger c = new AtomicInteger();

    public AbstractApnsService(ApnsFeedbackConnection feedback) {
        this.feedback = feedback;
    }

    @Override
    public void push(String deviceToken, String payload) throws NetworkIOException {
        this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, deviceToken, payload));
    }

    @Override
    public void push(String deviceToken, String payload, Date expiry) throws NetworkIOException {
        this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), (int)(expiry.getTime() / 1000L), deviceToken, payload));
    }

    @Override
    public void push(byte[] deviceToken, byte[] payload) throws NetworkIOException {
        this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, deviceToken, payload));
    }

    @Override
    public void push(byte[] deviceToken, byte[] payload, int expiry) throws NetworkIOException {
        this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), expiry, deviceToken, payload));
    }

    @Override
    public void push(Collection<String> deviceTokens, String payload) throws NetworkIOException {
        byte[] messageBytes = Utilities.toUTF8Bytes(payload);
        for (String deviceToken : deviceTokens) {
            byte[] dtbytes = Utilities.decodeHex(deviceToken);
            this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, dtbytes, messageBytes));
        }
    }

    @Override
    public void push(Collection<String> deviceTokens, String payload, Date expiry) throws NetworkIOException {
        byte[] messageBytes = Utilities.toUTF8Bytes(payload);
        for (String deviceToken : deviceTokens) {
            byte[] dtbytes = Utilities.decodeHex(deviceToken);
            this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), (int)(expiry.getTime() / 1000L), dtbytes, messageBytes));
        }
    }

    @Override
    public void push(Collection<byte[]> deviceTokens, byte[] payload) throws NetworkIOException {
        for (byte[] deviceToken : deviceTokens) {
            this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), Integer.MAX_VALUE, deviceToken, payload));
        }
    }

    @Override
    public void push(Collection<byte[]> deviceTokens, byte[] payload, int expiry) throws NetworkIOException {
        for (byte[] deviceToken : deviceTokens) {
            this.push(new EnhancedApnsNotification(this.c.incrementAndGet(), expiry, deviceToken, payload));
        }
    }

    @Override
    public abstract void push(ApnsNotification var1) throws NetworkIOException;

    @Override
    public Map<String, Date> getInactiveDevices() throws NetworkIOException {
        return this.feedback.getInactiveDevices();
    }
}

