/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.ReconnectPolicy;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ReconnectPolicies;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsConnectionImpl
implements ApnsConnection {
    private static final Logger logger = LoggerFactory.getLogger(ApnsConnectionImpl.class);
    private final SocketFactory factory;
    private final String host;
    private final int port;
    private final Socket underlyingSocket;
    private final ReconnectPolicy reconnectPolicy;
    private final ApnsDelegate delegate;
    private final boolean errorDetection;
    private Socket socket;
    int DELAY_IN_MS = 1000;
    private static final int RETRIES = 3;

    public ApnsConnectionImpl(SocketFactory factory, String host, int port) {
        this(factory, host, port, new ReconnectPolicies.Never(), ApnsDelegate.EMPTY);
    }

    public ApnsConnectionImpl(SocketFactory factory, String host, int port, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate) {
        this(factory, host, port, null, reconnectPolicy, delegate, false);
    }

    public ApnsConnectionImpl(SocketFactory factory, String host, int port, Socket underlyingSocket, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate, boolean errorDetection) {
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.reconnectPolicy = reconnectPolicy;
        this.delegate = delegate == null ? ApnsDelegate.EMPTY : delegate;
        this.underlyingSocket = underlyingSocket;
        this.errorDetection = errorDetection;
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            logger.debug("Error while closing socket connection", e);
        }
    }

    private void monitorSocket(final Socket socket) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MonitoringThread
        extends Thread {
            MonitoringThread() {
            }

            @Override
            public void run() {
                try {
                    InputStream in = socket.getInputStream();
                    int expectedSize = 6;
                    byte[] bytes = new byte[6];
                    while (in.read(bytes) == 6) {
                        int command = bytes[0] & 0xFF;
                        assert (command == 8);
                        int statusCode = bytes[1] & 0xFF;
                        DeliveryError e = DeliveryError.ofCode(statusCode);
                        int id = Utilities.parseBytes(bytes[2], bytes[3], bytes[4], bytes[5]);
                        ApnsConnectionImpl.this.delegate.connectionClosed(e, id);
                    }
                }
                catch (Exception e) {
                    logger.warn("Exception while waiting for error code", e);
                }
            }
        }
        MonitoringThread t = new MonitoringThread();
        t.setDaemon(true);
        t.start();
    }

    private synchronized Socket socket() throws NetworkIOException {
        if (this.reconnectPolicy.shouldReconnect()) {
            Utilities.close(this.socket);
            this.socket = null;
        }
        if (this.socket == null || this.socket.isClosed()) {
            try {
                if (this.underlyingSocket == null) {
                    this.socket = this.factory.createSocket(this.host, this.port);
                } else {
                    this.underlyingSocket.connect(new InetSocketAddress(this.host, this.port));
                    this.socket = ((SSLSocketFactory)this.factory).createSocket(this.underlyingSocket, this.host, this.port, false);
                }
                if (this.errorDetection) {
                    this.monitorSocket(this.socket);
                }
                this.reconnectPolicy.reconnected();
                logger.debug("Made a new connection to APNS");
            }
            catch (IOException e) {
                logger.error("Couldn't connect to APNS server", e);
                throw new NetworkIOException(e);
            }
        }
        return this.socket;
    }

    public synchronized void sendMessage(ApnsNotification m) throws NetworkIOException {
        int attempts = 0;
        while (true) {
            try {
                ++attempts;
                Socket socket = this.socket();
                socket.getOutputStream().write(m.marshall());
                socket.getOutputStream().flush();
                this.delegate.messageSent(m);
                logger.debug("Message \"{}\" sent", m);
                attempts = 0;
            }
            catch (Exception e) {
                if (attempts >= 3) {
                    logger.error("Couldn't send message " + m, e);
                    this.delegate.messageSendFailed(m, e);
                    Utilities.wrapAndThrowAsRuntimeException(e);
                }
                logger.warn("Failed to send message " + m + "... trying again", e);
                if (attempts != 1) {
                    Utilities.sleep(this.DELAY_IN_MS);
                }
                Utilities.close(this.socket);
                this.socket = null;
                continue;
            }
            break;
        }
    }

    public ApnsConnectionImpl copy() {
        return new ApnsConnectionImpl(this.factory, this.host, this.port, this.reconnectPolicy.copy(), this.delegate);
    }

    public void testConnection() throws NetworkIOException {
        ApnsConnectionImpl testConnection = new ApnsConnectionImpl(this.factory, this.host, this.port, this.reconnectPolicy.copy(), ApnsDelegate.EMPTY);
        testConnection.sendMessage(new SimpleApnsNotification(new byte[]{0}, new byte[]{0}));
        testConnection.close();
    }
}

