/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.internal.AbstractApnsService;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class MinaAdaptor
extends AbstractApnsService {
    NioSocketConnector connector;
    ConnectFuture cf;
    private final String host;
    private final int port;

    public MinaAdaptor(SSLContext sslContext, String host, int port) {
        this(sslContext, host, port, null);
    }

    public MinaAdaptor(SSLContext sslContext, String host, int port, ApnsFeedbackConnection feedback) {
        super(feedback);
        this.host = host;
        this.port = port;
        this.connector = this.createNioSocketConnector(sslContext);
    }

    private NioSocketConnector createNioSocketConnector(SSLContext sslContext) {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setConnectTimeoutMillis(30000L);
        connector.setHandler(new IoHandlerAdapter());
        SslFilter sslFilter = new SslFilter(sslContext);
        sslFilter.setUseClientMode(true);
        connector.getFilterChain().addLast("SSL", sslFilter);
        return connector;
    }

    public void push(ApnsNotification message) {
        byte[] msg = message.marshall();
        IoBuffer buf = IoBuffer.allocate(msg.length);
        System.arraycopy(msg, 0, buf.array(), 0, msg.length);
        this.cf.getSession().write(buf);
    }

    public void start() {
        this.cf = this.connector.connect(new InetSocketAddress(this.host, this.port));
        this.cf.awaitUninterruptibly();
    }

    public void stop() {
        Utilities.sleep(1000);
        this.cf.getSession().close(false).awaitUninterruptibly(100000L);
        this.connector.dispose();
    }

    public void testConnection() throws NetworkIOException {
    }
}

