/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.internal.AbstractApnsService;
import com.notnoop.exceptions.NetworkIOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuedApnsService
extends AbstractApnsService {
    private ApnsService service;
    private BlockingQueue<ApnsNotification> queue;
    private volatile boolean started = false;
    private Thread thread;
    private volatile boolean shouldContinue;

    public QueuedApnsService(ApnsService service) {
        super(null);
        this.service = service;
        this.queue = new LinkedBlockingQueue<ApnsNotification>();
        this.thread = null;
    }

    @Override
    public void push(ApnsNotification msg) {
        if (!this.started) {
            throw new IllegalStateException("service hasn't be started or was closed");
        }
        this.queue.add(msg);
    }

    @Override
    public void start() {
        this.started = true;
        this.service.start();
        if (this.thread != null) {
            this.stop();
        }
        this.shouldContinue = true;
        this.thread = new Thread(){

            public void run() {
                while (QueuedApnsService.this.shouldContinue) {
                    try {
                        ApnsNotification msg = (ApnsNotification)QueuedApnsService.this.queue.take();
                        QueuedApnsService.this.service.push(msg);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.start();
    }

    @Override
    public void stop() {
        this.started = false;
        this.shouldContinue = false;
        this.thread.interrupt();
        this.service.stop();
    }

    @Override
    public Map<String, Date> getInactiveDevices() throws NetworkIOException {
        return this.service.getInactiveDevices();
    }

    @Override
    public void testConnection() throws NetworkIOException {
        this.service.testConnection();
    }
}

