/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.ByteUtils;

public class LongUtils {
    private LongUtils() {
    }

    public static long longFromByteArray(byte[] bytes, int offset) {
        long out = 0L;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 0]) << 56;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 1]) << 48;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 2]) << 40;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 3]) << 32;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 4]) << 24;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 5]) << 16;
        out |= (long)ByteUtils.toUnsigned(bytes[offset + 6]) << 8;
        return out |= (long)ByteUtils.toUnsigned(bytes[offset + 7]) << 0;
    }

    public static byte[] byteArrayFromLong(long l) {
        byte[] out = new byte[8];
        LongUtils.longIntoByteArray(l, 0, out);
        return out;
    }

    public static void longIntoByteArray(long l, int offset, byte[] bytes) {
        bytes[offset + 0] = (byte)(l >>> 56 & 0xFFL);
        bytes[offset + 1] = (byte)(l >>> 48 & 0xFFL);
        bytes[offset + 2] = (byte)(l >>> 40 & 0xFFL);
        bytes[offset + 3] = (byte)(l >>> 32 & 0xFFL);
        bytes[offset + 4] = (byte)(l >>> 24 & 0xFFL);
        bytes[offset + 5] = (byte)(l >>> 16 & 0xFFL);
        bytes[offset + 6] = (byte)(l >>> 8 & 0xFFL);
        bytes[offset + 7] = (byte)(l >>> 0 & 0xFFL);
    }

    public static int fullHashLong(long l) {
        return LongUtils.hashLong(l);
    }

    public static int hashLong(long l) {
        return (int)l ^ (int)(l >>> 32);
    }
}

