/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.CookieNotFoundException;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieParser {
    private HttpServletRequest req;
    private Hashtable cookieJar = new Hashtable();

    public CookieParser(HttpServletRequest httpServletRequest) {
        this.req = httpServletRequest;
        this.parseCookies();
    }

    void parseCookies() {
        Cookie[] cookieArray = this.req.getCookies();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                String string = cookieArray[n].getName();
                String string2 = cookieArray[n].getValue();
                this.cookieJar.put(string, string2);
                ++n;
            }
        }
    }

    public String getStringCookie(String string) throws CookieNotFoundException {
        String string2 = (String)this.cookieJar.get(string);
        if (string2 == null) {
            throw new CookieNotFoundException(string + " not found");
        }
        return string2;
    }

    public String getStringCookie(String string, String string2) {
        try {
            return this.getStringCookie(string);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public boolean getBooleanCookie(String string) throws CookieNotFoundException {
        return new Boolean(this.getStringCookie(string));
    }

    public boolean getBooleanCookie(String string, boolean bl) {
        try {
            return this.getBooleanCookie(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public byte getByteCookie(String string) throws CookieNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getStringCookie(string));
    }

    public byte getByteCookie(String string, byte by) {
        try {
            return this.getByteCookie(string);
        }
        catch (Exception exception) {
            return by;
        }
    }

    public char getCharCookie(String string) throws CookieNotFoundException {
        String string2 = this.getStringCookie(string);
        if (string2.length() == 0) {
            throw new CookieNotFoundException(string + " is empty string");
        }
        return string2.charAt(0);
    }

    public char getCharCookie(String string, char c) {
        try {
            return this.getCharCookie(string);
        }
        catch (Exception exception) {
            return c;
        }
    }

    public double getDoubleCookie(String string) throws CookieNotFoundException, NumberFormatException {
        return new Double(this.getStringCookie(string));
    }

    public double getDoubleCookie(String string, double d) {
        try {
            return this.getDoubleCookie(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public float getFloatCookie(String string) throws CookieNotFoundException, NumberFormatException {
        return new Float(this.getStringCookie(string)).floatValue();
    }

    public float getFloatCookie(String string, float f) {
        try {
            return this.getFloatCookie(string);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public int getIntCookie(String string) throws CookieNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringCookie(string));
    }

    public int getIntCookie(String string, int n) {
        try {
            return this.getIntCookie(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long getLongCookie(String string) throws CookieNotFoundException, NumberFormatException {
        return Long.parseLong(this.getStringCookie(string));
    }

    public long getLongCookie(String string, long l) {
        try {
            return this.getLongCookie(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public short getShortCookie(String string) throws CookieNotFoundException, NumberFormatException {
        return Short.parseShort(this.getStringCookie(string));
    }

    public short getShortCookie(String string, short s) {
        try {
            return this.getShortCookie(string);
        }
        catch (Exception exception) {
            return s;
        }
    }
}

