/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.adapter;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderParameters;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.adapter.SimpleClassLoaderAdapter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.URLPath;

public class AntClassLoaderAdapter
extends SimpleClassLoaderAdapter {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public boolean appendClasspath(ClassloaderContext.CreateModify createModify, ClassLoader classLoader) {
        return this.appendClasspath(createModify, classLoader, createModify.getClasspathFiles());
    }

    private boolean appendClasspath(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, String[] stringArray) {
        try {
            Method method = classLoader.getClass().getMethod("addPathElement", class$java$lang$String == null ? (class$java$lang$String = AntClassLoaderAdapter.class$("java.lang.String")) : class$java$lang$String);
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (file.exists()) {
                    String string = createModify.getURLUtil().createURL(file.getAbsolutePath()).toString();
                    if (!createModify.handleClasspathEntry(classLoader, string)) continue;
                    method.invoke((Object)classLoader, file.getAbsolutePath());
                    createModify.handleDebug("AntClassLoader " + createModify.getLoaderName() + ": adding path " + file.getAbsolutePath());
                    continue;
                }
                createModify.handleWarning("AntClassLoader " + createModify.getLoaderName() + ": ignoring nonexistent path " + file.getAbsolutePath());
            }
            return true;
        }
        catch (Exception exception) {
            createModify.handleError("can not add Path to AntClassLoader", exception);
            return false;
        }
    }

    public String[] getClasspath(ClassloaderContext classloaderContext, ClassLoader classLoader, boolean bl) {
        try {
            String string = (String)classLoader.getClass().getMethod("getClasspath", null).invoke((Object)classLoader, null);
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (Exception exception) {
            classloaderContext.handleError("unable to get Classpath", exception);
            return null;
        }
    }

    public ClassLoader getDefaultParent() {
        return ClassLoader.getSystemClassLoader();
    }

    protected String getDefaultParentName() {
        return "SystemClassLoader";
    }

    public ClassLoader getParent(ClassLoader classLoader) {
        try {
            ClassLoader classLoader2 = classLoader.getClass().getClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ClassLoader.getSystemClassLoader();
            }
            Field field = classLoader2.loadClass((class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = AntClassLoaderAdapter.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getName()).getDeclaredField("parent");
            field.setAccessible(true);
            return (ClassLoader)field.get(classLoader);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private boolean handleAddJavaLibraries(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, String string, boolean bl) {
        if (!bl) {
            return true;
        }
        try {
            Method method = classLoader.getClass().getMethod("addJavaLibraries", null);
            method.invoke((Object)classLoader, null);
            createModify.handleDebug("Loader " + string + ": calling addJavaLibraries");
            return true;
        }
        catch (Exception exception) {
            createModify.handleError("unable to call addJavaLibraries on AntClassLoader " + string, exception);
            return false;
        }
    }

    private boolean handleAddLoaderPackageRoot(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, String string, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        try {
            Method method = classLoader.getClass().getMethod("addLoaderPackageRoot", class$java$lang$String == null ? (class$java$lang$String = AntClassLoaderAdapter.class$("java.lang.String")) : class$java$lang$String);
            for (int i = 0; i < stringArray.length; ++i) {
                method.invoke((Object)classLoader, stringArray[i]);
                createModify.handleDebug("Loader " + string + ": calling addLoaderPackageRoot(\"" + stringArray[i] + "\")");
            }
            return true;
        }
        catch (Exception exception) {
            createModify.handleError("unable to call addLoaderPackageRoot on AntClassLoader " + string, exception);
            return false;
        }
    }

    private boolean handleAddSystemPackageRoot(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, String string, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        try {
            Method method = classLoader.getClass().getMethod("addSystemPackageRoot", class$java$lang$String == null ? (class$java$lang$String = AntClassLoaderAdapter.class$("java.lang.String")) : class$java$lang$String);
            for (int i = 0; i < stringArray.length; ++i) {
                method.invoke((Object)classLoader, stringArray[i]);
                createModify.handleDebug("Loader " + string + ": calling addSystemPackageRoot(\"" + stringArray[i] + "\")");
            }
            return true;
        }
        catch (Exception exception) {
            createModify.handleError("unable to call addSystemPackageRoot on AntClassLoader " + string, exception);
            return false;
        }
    }

    private ClassLoader handleCreateLoader(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, Path path, String string) {
        ClassLoader classLoader2 = null;
        try {
            classLoader2 = (ClassLoader)Class.forName("org.apache.tools.ant.loader.AntClassLoader2", true, classLoader).newInstance();
            createModify.handleDebug("AntClassLoader " + string + " created");
            Class<?> clazz = Class.forName("org.apache.tools.ant.Project", true, classLoader);
            Class<?> clazz2 = Class.forName("org.apache.tools.ant.Project", true, createModify.getAntProject().getClass().getClassLoader());
            if (clazz == clazz2) {
                classLoader2.getClass().getMethod("setProject", clazz).invoke((Object)classLoader2, createModify.getAntProject());
            } else {
                createModify.handleWarning("can not set project for AntClassLoader " + string + ": Project classes are not compatible");
            }
            if (!this.appendClasspath(createModify, classLoader2, path.list())) {
                return null;
            }
            return classLoader2;
        }
        catch (Exception exception) {
            createModify.handleError("Unable to create AntClassLoader " + string + ": " + exception.getMessage(), exception);
            return null;
        }
    }

    private boolean handleSetIsolated(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, String string, boolean bl) {
        if (!bl) {
            return true;
        }
        try {
            Method method = classLoader.getClass().getMethod("setIsolated", Boolean.TYPE);
            method.invoke((Object)classLoader, Boolean.TRUE);
            createModify.handleDebug("Loader " + string + ": setting isolated=true");
            return true;
        }
        catch (Exception exception) {
            createModify.handleError("unable to call setIsolated on AntClassLoader " + string, exception);
            return false;
        }
    }

    private void handleSetParent(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, ClassLoader classLoader2, String string) {
        if (classLoader2 == null) {
            return;
        }
        try {
            Method method = classLoader.getClass().getMethod("setParent", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AntClassLoaderAdapter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            method.invoke((Object)classLoader, classLoader2);
            createModify.handleDebug("Loader " + string + ": setting parentLoader");
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private boolean handleSetParentFirst(ClassloaderContext.CreateModify createModify, ClassLoader classLoader, String string, boolean bl) {
        if (bl) {
            return true;
        }
        try {
            Method method = classLoader.getClass().getMethod("setParentFirst", Boolean.TYPE);
            method.invoke((Object)classLoader, Boolean.FALSE);
            createModify.handleDebug("Loader " + string + ": setting parentFirst=false");
            return true;
        }
        catch (Exception exception) {
            createModify.handleError("unable to call setParentFirst on AntClassLoader " + string, exception);
            return false;
        }
    }

    protected ClassLoader initClassLoader(ClassloaderContext.CreateModify createModify, ClassLoader classLoader) {
        ClassLoaderParameters classLoaderParameters = createModify.getParameters().getParameters();
        if (classLoaderParameters instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)classLoaderParameters;
            String string = createModify.getLoaderName();
            if (!this.handleSetIsolated(createModify, classLoader, string, descriptor.isIsolated())) {
                return null;
            }
            if (!this.handleSetParentFirst(createModify, classLoader, string, descriptor.isParentFirst())) {
                return null;
            }
            if (!this.handleAddJavaLibraries(createModify, classLoader, string, descriptor.isAddJavaLibraries())) {
                return null;
            }
            if (!this.handleAddLoaderPackageRoot(createModify, classLoader, string, descriptor.getLoaderPackageRoot())) {
                return null;
            }
            if (!this.handleAddSystemPackageRoot(createModify, classLoader, string, descriptor.getSystemPackageRoot())) {
                return null;
            }
        }
        return super.initClassLoader(createModify, classLoader);
    }

    public boolean isSupported(ClassLoaderAdapterAction classLoaderAdapterAction) {
        return true;
    }

    protected ClassLoader newClassLoader(ClassloaderContext.CreateModify createModify) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = createModify.getSuperLoader();
        ClassLoader classLoader3 = createModify.getParentLoader();
        String string = createModify.getLoaderName();
        String[] stringArray = createModify.getClasspathURLs();
        URLPath uRLPath = null;
        if (stringArray != null) {
            classLoader = classLoader3;
            if (classLoader == null) {
                classLoader = this.getDefaultParent();
            }
            HashSet<String> hashSet = new HashSet<String>();
            uRLPath = new URLPath((Project)createModify.getAntProject());
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    URL uRL = createModify.getURLUtil().createURL(stringArray[i]);
                    String string2 = uRL.toString();
                    if (!hashSet.add(string2) || !createModify.handleClasspathEntry(classLoader, string2)) continue;
                    uRLPath.addURLPath(new URLPath(uRLPath.getProject(), string2));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    createModify.handleError("createURL(\"" + stringArray[i] + "\")", malformedURLException);
                }
            }
        }
        if (classLoader2 == null) {
            classLoader = ((Project)createModify.getAntProject()).createClassLoader(uRLPath == null ? null : uRLPath.toPath());
        } else {
            classLoader = this.handleCreateLoader(createModify, classLoader2, uRLPath == null ? null : uRLPath.toPath(), string);
            if (classLoader == null) {
                return null;
            }
        }
        this.handleSetParent(createModify, classLoader, classLoader3, string);
        return classLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Descriptor
    extends ClassLoaderParameters {
        public String[] getLoaderPackageRoot();

        public String[] getSystemPackageRoot();

        public boolean isAddJavaLibraries();

        public boolean isIsolated();

        public boolean isParentFirst();
    }
}

