/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public final class ClassloaderReportTreeBuilder
implements ClassloaderReportBuilder {
    private Map cLbyHandle = new HashMap();
    private CL currentCL;
    private ArrayList errors = new ArrayList();
    private SortedSet unassigned = new TreeSet();
    private final ClassloaderContext.Report context;

    public ClassloaderReportTreeBuilder(ClassloaderContext.Report report) {
        this.context = report;
    }

    public void beginAttributes(int n) {
    }

    public void beginChildLoaders(int n) {
    }

    public void beginClassloader(ClassloaderReportHandle classloaderReportHandle) {
        this.currentCL = new CL(classloaderReportHandle);
        this.cLbyHandle.put(classloaderReportHandle, this.currentCL);
    }

    public void beginEntries(int n) {
    }

    public void beginErrors(int n) {
    }

    public void beginPackages(int n) {
    }

    public void beginReport() {
    }

    public void beginRoles(int n) {
    }

    public void beginUnassignedRoles(int n) {
    }

    public void endAttributes(int n) {
    }

    public void endChildLoaders(int n) {
    }

    public void endClassloader(ClassloaderReportHandle classloaderReportHandle) {
    }

    public void endEntries(int n) {
    }

    public void endErrors(int n) {
    }

    public void endPackages(int n) {
    }

    public void endReport() {
    }

    public void endRoles(int n) {
    }

    public void endUnassignedRoles(int n) {
    }

    public void execute(ClassloaderReporter classloaderReporter) {
        Object object;
        classloaderReporter.beginReport();
        if (this.errors.size() > 0) {
            classloaderReporter.beginErrors(this.errors.size());
            object = this.errors.iterator();
            while (object.hasNext()) {
                classloaderReporter.reportError((String)object.next());
            }
            classloaderReporter.endErrors(this.errors.size());
        }
        if (this.unassigned.size() > 0) {
            classloaderReporter.beginUnassignedRoles(this.unassigned.size());
            object = this.unassigned.iterator();
            while (object.hasNext()) {
                classloaderReporter.reportUnassignedRole((ClassloaderReportHandle)object.next());
            }
            classloaderReporter.endUnassignedRoles(this.unassigned.size());
        }
        object = this.cLbyHandle.values().iterator();
        while (object.hasNext()) {
            ((CL)object.next()).childs = new TreeMap();
        }
        object = new TreeMap();
        Iterator iterator = this.cLbyHandle.values().iterator();
        while (iterator.hasNext()) {
            CL cL = (CL)iterator.next();
            if (cL.parent == null) {
                ((TreeMap)object).put(cL.handle, cL);
                continue;
            }
            CL cL2 = (CL)this.cLbyHandle.get(cL.parent);
            if (cL2 == null) {
                throw new RuntimeException("internal error: " + cL.parent + " not found");
            }
            cL2.childs.put(cL.handle, cL);
        }
        iterator = ((TreeMap)object).values().iterator();
        while (iterator.hasNext()) {
            this.execute(classloaderReporter, (CL)iterator.next());
        }
        classloaderReporter.endReport();
    }

    private void execute(ClassloaderReporter classloaderReporter, CL cL) {
        Object object;
        Iterator<Object> iterator;
        classloaderReporter.beginClassloader(cL.handle);
        if (cL.parent != null) {
            if (cL.expliciteParent) {
                classloaderReporter.reportExlicitelyParent(cL.parent);
            } else {
                classloaderReporter.reportImplicitelyParent(cL.parent);
            }
        }
        if (cL.clazz != null) {
            classloaderReporter.reportClass(cL.clazz);
        }
        if (cL.attributes != null) {
            classloaderReporter.beginAttributes(cL.attributes.size());
            iterator = cL.attributes.iterator();
            while (iterator.hasNext()) {
                object = (CL.Attr)iterator.next();
                classloaderReporter.reportAttribute(((CL.Attr)object).name, ((CL.Attr)object).value);
            }
            classloaderReporter.endAttributes(cL.attributes.size());
        }
        if (cL.entries != null) {
            classloaderReporter.beginEntries(cL.entries.size());
            iterator = cL.entries.iterator();
            while (iterator.hasNext()) {
                object = (CL.Entry)iterator.next();
                classloaderReporter.reportEntry(((CL.Entry)object).type, ((CL.Entry)object).value);
            }
            classloaderReporter.endEntries(cL.entries.size());
        }
        if (cL.roles != null) {
            classloaderReporter.beginRoles(cL.roles.size());
            iterator = cL.roles.iterator();
            while (iterator.hasNext()) {
                classloaderReporter.reportRole((ClassloaderReportHandle)iterator.next());
            }
            classloaderReporter.endRoles(cL.roles.size());
        }
        if (this.context.isReportPackages() && cL.packages != null) {
            classloaderReporter.beginPackages(cL.packages.size());
            iterator = cL.packages.iterator();
            while (iterator.hasNext()) {
                classloaderReporter.reportPackage((String)iterator.next());
            }
            classloaderReporter.endPackages(cL.packages.size());
        }
        if (cL.childs.size() > 0) {
            classloaderReporter.beginChildLoaders(cL.childs.size());
            iterator = cL.childs.values().iterator();
            while (iterator.hasNext()) {
                this.execute(classloaderReporter, (CL)iterator.next());
            }
            classloaderReporter.endChildLoaders(cL.childs.size());
        }
        classloaderReporter.endClassloader(cL.handle);
    }

    public void reportAttribute(String string, String string2) {
        this.currentCL.attributes.add(new CL.Attr(string, string2));
    }

    public void reportChild(ClassloaderReportHandle classloaderReportHandle) {
    }

    public void reportClass(Class clazz) {
        this.currentCL.clazz = clazz;
    }

    public void reportEntry(String string, String string2) {
        this.currentCL.entries.add(new CL.Entry(string, string2));
    }

    public void reportEntry(URL uRL) {
        this.reportEntry("url", uRL.toString());
    }

    public void reportError(String string) {
        this.errors.add(string);
    }

    public void reportExlicitelyParent(ClassloaderReportHandle classloaderReportHandle) {
        this.currentCL.parent = classloaderReportHandle;
        this.currentCL.expliciteParent = true;
    }

    public void reportImplicitelyParent(ClassloaderReportHandle classloaderReportHandle) {
        this.currentCL.parent = classloaderReportHandle;
        this.currentCL.expliciteParent = false;
    }

    public void reportPackage(String string) {
        this.currentCL.packages.add(string);
    }

    public void reportRole(ClassloaderReportHandle classloaderReportHandle) {
        this.currentCL.roles.add(classloaderReportHandle);
    }

    public void reportUnassignedRole(ClassloaderReportHandle classloaderReportHandle) {
        this.unassigned.add(classloaderReportHandle);
    }

    private static class CL {
        private ArrayList attributes = new ArrayList();
        private SortedMap childs;
        private Class clazz = null;
        private ArrayList entries = new ArrayList();
        private boolean expliciteParent;
        private final ClassloaderReportHandle handle;
        private SortedSet packages = new TreeSet();
        private ClassloaderReportHandle parent;
        private SortedSet roles = new TreeSet();

        public CL(ClassloaderReportHandle classloaderReportHandle) {
            this.handle = classloaderReportHandle;
        }

        private static class Entry {
            private final String type;
            private final String value;

            Entry(String string, String string2) {
                this.type = string;
                this.value = string2;
            }
        }

        private static class Attr {
            private final String name;
            private final String value;

            Attr(String string, String string2) {
                this.name = string;
                this.value = string2;
            }
        }
    }
}

