/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public class ClassloaderReportUtil {
    private static ClassloaderReportUtil singleton = new ClassloaderReportUtil();

    public static ClassloaderReportUtil getReportUtil() {
        return singleton;
    }

    public static void setReportUtil(ClassloaderReportUtil classloaderReportUtil) {
        if (classloaderReportUtil != null) {
            singleton = classloaderReportUtil;
        }
    }

    protected ClassloaderReportUtil() {
    }

    public boolean addLoaderToReport(ClassloaderContext.Report report, ClassLoader classLoader, ClassloaderReportHandle classloaderReportHandle, Map map, Map map2, ClassloaderReporter classloaderReporter) {
        Object object = map2.put(classloaderReportHandle, classLoader);
        if (object != null) {
            throw new RuntimeException("duplicate classloader " + classloaderReportHandle);
        }
        if (classLoader != null) {
            boolean bl;
            object = map.get(classLoader);
            boolean bl2 = bl = object == null;
            if (object == null) {
                object = new TreeSet();
                map.put(classLoader, object);
            }
            ((Set)object).add(classloaderReportHandle);
            if (bl) {
                boolean bl3;
                ClassLoaderAdapter classLoaderAdapter = report.getUtil().findAdapter((ClassloaderContext)report, classLoader, null, classloaderReporter, classloaderReportHandle + "->parent", classloaderReportHandle.getName());
                boolean bl4 = bl3 = classLoaderAdapter != null;
                if (bl3) {
                    ClassLoader classLoader2 = classLoaderAdapter.getParent(classLoader);
                    if (classLoader2 == null) {
                        classLoader2 = classLoaderAdapter.getDefaultParent();
                    }
                    if (classLoader2 != null) {
                        this.addLoaderToReport(report, classLoaderAdapter.getParent(classLoader), new ClassloaderReportHandle(9, classloaderReportHandle.toString()), map, map2, classloaderReporter);
                    }
                }
                if ((classLoaderAdapter = report.getUtil().findAdapter((ClassloaderContext)report, classLoader, ClassLoaderAdapterAction.REPORT, classloaderReporter, "report for " + classloaderReportHandle, "")) != null) {
                    classLoaderAdapter.addReportable(report, classLoader, classloaderReportHandle, map, map2);
                }
                return bl3 && classLoaderAdapter != null;
            }
        }
        return true;
    }

    public void report(ClassloaderContext.Report report, ClassloaderReporter classloaderReporter, ClassLoader classLoader, ClassloaderReportHandle classloaderReportHandle, Map map) {
        Object object;
        Object object2;
        classloaderReporter.beginClassloader(classloaderReportHandle);
        ClassLoaderAdapter classLoaderAdapter = report.getUtil().findAdapter((ClassloaderContext)report, classLoader, null, classloaderReporter, "parent for " + classloaderReportHandle, "");
        if (classLoaderAdapter != null) {
            object2 = classLoaderAdapter.getParent(classLoader);
            if (object2 != null) {
                object = (SortedSet)map.get(object2);
                classloaderReporter.reportExlicitelyParent((ClassloaderReportHandle)object.first());
            } else {
                object2 = classLoaderAdapter.getDefaultParent();
                if (object2 != null) {
                    object = (SortedSet)map.get(object2);
                    classloaderReporter.reportImplicitelyParent((ClassloaderReportHandle)object.first());
                } else {
                    classloaderReporter.reportImplicitelyParent(ClassloaderReportHandle.BOOTSTRAPHANDLE);
                }
            }
        }
        classloaderReporter.reportClass(classLoader.getClass());
        object2 = (SortedSet)map.get(classLoader);
        object = object2.iterator();
        while (object.hasNext()) {
            classloaderReporter.reportRole((ClassloaderReportHandle)object.next());
        }
        object = report.getUtil().findAdapter((ClassloaderContext)report, classLoader, ClassLoaderAdapterAction.GETPATH, classloaderReporter, "entries for " + classloaderReportHandle, "");
        if (object != null) {
            String[] stringArray = object.getClasspath(report, classLoader, false);
            if (stringArray == null) {
                classloaderReporter.reportError("entries for " + classloaderReportHandle + " not investigatable (adapter retrieves no path)");
            } else {
                classloaderReporter.beginEntries(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    classloaderReporter.reportEntry("url", stringArray[i]);
                }
            }
        }
        if (report.isReportPackages()) {
            this.reportPackages(report, classloaderReporter, classLoaderAdapter, classLoader, classloaderReportHandle);
        }
        if ((object = report.getUtil().findAdapter((ClassloaderContext)report, classLoader, ClassLoaderAdapterAction.REPORT, classloaderReporter, "additional parameters for " + classloaderReportHandle, "")) != null) {
            object.report(classloaderReporter, report, classLoader, classloaderReportHandle);
        }
    }

    public void report(ClassloaderContext.Report report, Map map, Map map2, ClassloaderReporter classloaderReporter, boolean bl) {
        URL[] uRLArray;
        classloaderReporter.beginReport();
        if (!bl) {
            classloaderReporter.reportError("WARNING: As of missing Loaderhandlers, this report might not be complete.");
        }
        if ((uRLArray = report.getUtil().getBootstrapClasspathURLs()) == null) {
            classloaderReporter.reportError("WARNING: Unable to determine bootstrap classpath.\n         Please report this error to Ant's bugtracking  system with information\n         about your environment  (JVM-Vendor, JVM-Version, OS, application context).");
        } else {
            classloaderReporter.beginClassloader(ClassloaderReportHandle.BOOTSTRAPHANDLE);
            classloaderReporter.beginEntries(uRLArray.length);
            for (int i = 0; i < uRLArray.length; ++i) {
                classloaderReporter.reportEntry(uRLArray[i]);
            }
            classloaderReporter.endEntries(uRLArray.length);
            classloaderReporter.endClassloader(ClassloaderReportHandle.BOOTSTRAPHANDLE);
        }
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            ClassloaderReportHandle classloaderReportHandle = (ClassloaderReportHandle)iterator.next();
            ClassLoader classLoader = (ClassLoader)map2.get(classloaderReportHandle);
            if (classLoader == null) {
                if (!classloaderReportHandle.isPopular()) continue;
                classloaderReporter.reportUnassignedRole(classloaderReportHandle);
                continue;
            }
            SortedSet sortedSet = (SortedSet)map.get(classLoader);
            if (!classloaderReportHandle.equals(sortedSet.first())) continue;
            this.report(report, classloaderReporter, classLoader, classloaderReportHandle, map);
        }
        classloaderReporter.endReport();
    }

    private void reportPackages(ClassloaderContext.Report report, ClassloaderReporter classloaderReporter, ClassLoaderAdapter classLoaderAdapter, ClassLoader classLoader, ClassloaderReportHandle classloaderReportHandle) {
        Package[] packageArray = classLoaderAdapter.getPackages(report, classLoader, classloaderReportHandle);
        if (packageArray == null) {
            classloaderReporter.reportError("packages of " + classloaderReportHandle + " not investigatable");
        } else {
            Arrays.sort(packageArray, PackageComparator.SINGLETON);
            classloaderReporter.beginPackages(packageArray.length);
            for (int i = 0; i < packageArray.length; ++i) {
                classloaderReporter.reportPackage(packageArray[i].getName());
            }
            classloaderReporter.endPackages(packageArray.length);
        }
    }

    private static final class PackageComparator
    implements Comparator {
        public static final Comparator SINGLETON = new PackageComparator();

        private PackageComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Package)object).getName().compareTo(((Package)object2).getName());
        }
    }
}

