/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public final class LoaderHandler
extends DataType
implements ClassLoaderHandler,
Cloneable {
    private static final LoaderHandler[] DEFAULT_HANDLERS = new LoaderHandler[]{new LoaderHandler("ant.clhandler.URLClassLoader", (class$org$apache$tools$ant$taskdefs$classloader$adapter$URLClassLoaderAdapter == null ? (class$org$apache$tools$ant$taskdefs$classloader$adapter$URLClassLoaderAdapter = LoaderHandler.class$("org.apache.tools.ant.taskdefs.classloader.adapter.URLClassLoaderAdapter")) : class$org$apache$tools$ant$taskdefs$classloader$adapter$URLClassLoaderAdapter).getName(), (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = LoaderHandler.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getName()), new LoaderHandler("ant.clhandler.AntClassLoader", (class$org$apache$tools$ant$taskdefs$classloader$adapter$AntClassLoaderAdapter == null ? (class$org$apache$tools$ant$taskdefs$classloader$adapter$AntClassLoaderAdapter = LoaderHandler.class$("org.apache.tools.ant.taskdefs.classloader.adapter.AntClassLoaderAdapter")) : class$org$apache$tools$ant$taskdefs$classloader$adapter$AntClassLoaderAdapter).getName(), (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = LoaderHandler.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getName()), new LoaderHandler("ant.clhandler.ClassLoader", (class$org$apache$tools$ant$taskdefs$classloader$adapter$SimpleClassLoaderAdapter == null ? (class$org$apache$tools$ant$taskdefs$classloader$adapter$SimpleClassLoaderAdapter = LoaderHandler.class$("org.apache.tools.ant.taskdefs.classloader.adapter.SimpleClassLoaderAdapter")) : class$org$apache$tools$ant$taskdefs$classloader$adapter$SimpleClassLoaderAdapter).getName(), (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = LoaderHandler.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName())};
    private String adapter = null;
    private String desiredId = null;
    private String loader = null;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$classloader$adapter$URLClassLoaderAdapter;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$classloader$adapter$AntClassLoaderAdapter;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$classloader$adapter$SimpleClassLoaderAdapter;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$types$LoaderHandler;

    public static void addPredefined(Project project) {
        for (int i = 0; i < DEFAULT_HANDLERS.length; ++i) {
            DEFAULT_HANDLERS[i].setDesiredId(project);
        }
    }

    public static ClassLoaderHandler[] getDefaultHandlers(Project project) {
        LoaderHandler.addPredefined(project);
        ArrayList<Object> arrayList = new ArrayList<Object>(DEFAULT_HANDLERS.length);
        for (int i = 0; i < DEFAULT_HANDLERS.length; ++i) {
            Object object = project.getReference(LoaderHandler.DEFAULT_HANDLERS[i].desiredId);
            if (object == null || !(object instanceof LoaderHandler)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new ClassLoaderHandler[arrayList.size()]);
    }

    public static ClassLoaderHandler[] getAllHandlers(Project project) {
        LoaderHandler.addPredefined(project);
        ArrayList<Object> arrayList = new ArrayList<Object>(DEFAULT_HANDLERS.length);
        Iterator iterator = project.getReferences().keySet().iterator();
        while (iterator.hasNext()) {
            Object object = project.getReference((String)iterator.next());
            if (object == null || !(object instanceof LoaderHandler) || ((LoaderHandler)object).isReference()) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new ClassLoaderHandler[arrayList.size()]);
    }

    private LoaderHandler() {
    }

    public LoaderHandler(Project project) {
        this.setProject(project);
        LoaderHandler.addPredefined(project);
    }

    public LoaderHandler(Project project, Reference reference) {
        this(project);
        this.setRefid(reference);
        this.check();
    }

    private LoaderHandler(String string, String string2, String string3) {
        this.desiredId = string;
        this.adapter = string2;
        this.loader = string3;
        this.check();
    }

    public void check() {
        if (this.isReference()) {
            LoaderHandler loaderHandler = (LoaderHandler)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderHandler == null ? (class$org$apache$tools$ant$types$LoaderHandler = LoaderHandler.class$("org.apache.tools.ant.types.LoaderHandler")) : class$org$apache$tools$ant$types$LoaderHandler, "LoaderHandler");
            loaderHandler.check();
        }
        if (this.loader == null) {
            throw new BuildException("attribute loader is mandatory");
        }
        if (this.adapter == null) {
            throw new BuildException("attribute adapter is mandatory");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException((Throwable)cloneNotSupportedException);
        }
    }

    private LoaderHandler clone(Project project) {
        LoaderHandler loaderHandler = (LoaderHandler)this.clone();
        loaderHandler.setProject(project);
        return loaderHandler;
    }

    public String getAdapter() {
        this.check();
        if (this.isReference()) {
            LoaderHandler loaderHandler = (LoaderHandler)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderHandler == null ? (class$org$apache$tools$ant$types$LoaderHandler = LoaderHandler.class$("org.apache.tools.ant.types.LoaderHandler")) : class$org$apache$tools$ant$types$LoaderHandler, "LoaderHandler");
            return loaderHandler.getAdapter();
        }
        return this.adapter;
    }

    public ClassLoaderAdapter getAdapter(ClassloaderContext classloaderContext) {
        this.check();
        if (this.isReference()) {
            LoaderHandler loaderHandler = (LoaderHandler)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderHandler == null ? (class$org$apache$tools$ant$types$LoaderHandler = LoaderHandler.class$("org.apache.tools.ant.types.LoaderHandler")) : class$org$apache$tools$ant$types$LoaderHandler, "LoaderHandler");
            return loaderHandler.getAdapter(classloaderContext);
        }
        try {
            return (ClassLoaderAdapter)Class.forName(this.adapter).newInstance();
        }
        catch (Exception exception) {
            classloaderContext.handleError("error instantiating ClassLoaderAdapter " + this.adapter, exception);
            return null;
        }
    }

    public String getLoader() {
        this.check();
        if (this.isReference()) {
            LoaderHandler loaderHandler = (LoaderHandler)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderHandler == null ? (class$org$apache$tools$ant$types$LoaderHandler = LoaderHandler.class$("org.apache.tools.ant.types.LoaderHandler")) : class$org$apache$tools$ant$types$LoaderHandler, "LoaderHandler");
            return loaderHandler.getLoader();
        }
        return this.loader;
    }

    public Class getLoaderClass(ClassloaderContext classloaderContext, ClassLoader classLoader, ClassLoaderAdapterAction classLoaderAdapterAction) {
        this.check();
        if (this.isReference()) {
            LoaderHandler loaderHandler = (LoaderHandler)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderHandler == null ? (class$org$apache$tools$ant$types$LoaderHandler = LoaderHandler.class$("org.apache.tools.ant.types.LoaderHandler")) : class$org$apache$tools$ant$types$LoaderHandler, "LoaderHandler");
            return loaderHandler.getLoaderClass(classloaderContext, classLoader, classLoaderAdapterAction);
        }
        try {
            Class<?> clazz = Class.forName(this.loader, true, classLoader.getClass().getClassLoader());
            if (!clazz.isAssignableFrom(classLoader.getClass())) {
                return null;
            }
            ClassLoaderAdapter classLoaderAdapter = this.getAdapter(classloaderContext);
            if (classLoaderAdapterAction != null && !classLoaderAdapter.isSupported(classLoaderAdapterAction)) {
                return null;
            }
            return clazz;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setAdapter(String string) {
        this.checkAttributesAllowed();
        this.adapter = string;
    }

    private void setDesiredId(Project project) {
        if (this.desiredId != null && project.getReference(this.desiredId) == null) {
            project.addReference(this.desiredId, (Object)this.clone(project));
        }
    }

    public void setLoader(String string) {
        this.checkAttributesAllowed();
        this.loader = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

