/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;

public class LoaderRef
extends DataType {
    private boolean failOnError = true;
    private LoaderSpec loader = null;
    private String loaderRef = null;
    static /* synthetic */ Class class$org$apache$tools$ant$types$LoaderRef;

    private LoaderRef() {
    }

    public LoaderRef(Project project) {
        this.setProject(project);
    }

    public LoaderRef(Project project, String string) {
        this(project);
        Object object = this.getProject().getReference(string);
        if (object == null) {
            try {
                this.loader = new LoaderSpec(string);
            }
            catch (Exception exception) {
                this.loaderRef = string;
            }
        } else if (object instanceof LoaderRef) {
            this.setRefid(new Reference(string));
        } else if (object instanceof ClassLoader) {
            this.loaderRef = string;
        } else {
            throw new BuildException("Reference " + string + " denotes an object of class " + object.getClass().getName() + " which is neither a org.apache.tools.ant.types.LoaderRef" + " nor a java.lang.ClassLoader");
        }
    }

    public ClassLoader getClassLoader(LoaderSpec loaderSpec) {
        return this.getClassLoader(loaderSpec, this.failOnError, true);
    }

    public ClassLoader getClassLoader(LoaderSpec loaderSpec, boolean bl, boolean bl2) {
        Object object = null;
        if (this.isReference()) {
            return this.getRef().getClassLoader(loaderSpec, bl, bl2);
        }
        if (this.loaderRef != null) {
            object = this.getProject().getReference(this.loaderRef);
            if (object == null) {
                if (bl2) {
                    return null;
                }
                this.handleError("Referenced object " + this.loaderRef + " not found", bl);
                return null;
            }
            if (!(object instanceof ClassLoader)) {
                this.handleError("Referenced object " + this.loaderRef + " is not a ClassLoader: " + object.getClass().getName(), bl);
                return null;
            }
            return (ClassLoader)object;
        }
        if (this.loader != null) {
            return this.loader.getClassLoader(this);
        }
        if (loaderSpec != null) {
            return loaderSpec.getClassLoader(this);
        }
        return null;
    }

    public ClassLoader getClassLoaderOrFallback(LoaderSpec loaderSpec, boolean bl, boolean bl2) {
        Object object = null;
        if (this.isReference()) {
            return this.getRef().getClassLoaderOrFallback(loaderSpec, bl, bl2);
        }
        if (this.loaderRef != null) {
            object = this.getProject().getReference(this.loaderRef);
            if (object == null) {
                if (bl2) {
                    return null;
                }
                this.handleError("Referenced object " + this.loaderRef + " not found", bl);
                return null;
            }
            if (!(object instanceof ClassLoader)) {
                this.handleError("Referenced object " + this.loaderRef + " is not a ClassLoader: " + object.getClass().getName(), bl);
                return null;
            }
            return (ClassLoader)object;
        }
        if (this.loader != null) {
            return this.loader.getClassloaderOrFallback(this);
        }
        if (loaderSpec != null) {
            return loaderSpec.getClassloaderOrFallback(this);
        }
        return null;
    }

    public String getLoaderId() {
        if (this.isReference()) {
            return this.getRef().getLoaderId();
        }
        if (this.loaderRef != null) {
            return this.loaderRef;
        }
        if (this.loader != null) {
            return LoaderSpec.MAGIC_NAMES[this.loader.getIndex()];
        }
        return null;
    }

    public String getName() {
        if (this.isReference()) {
            return this.getRef().getName();
        }
        if (this.loaderRef != null) {
            return this.loaderRef;
        }
        if (this.loader != null) {
            return this.loader.toString();
        }
        return null;
    }

    private LoaderRef getRef() {
        return (LoaderRef)((Object)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderRef == null ? (class$org$apache$tools$ant$types$LoaderRef = LoaderRef.class$("org.apache.tools.ant.types.LoaderRef")) : class$org$apache$tools$ant$types$LoaderRef, "loaderRef"));
    }

    public void handleError(String string) {
        this.handleError(string, null, this.failOnError);
    }

    public void handleError(String string, boolean bl) {
        this.handleError(string, null, bl);
    }

    public void handleError(String string, Throwable throwable) {
        this.handleError(string, null, this.failOnError);
    }

    public void handleError(String string, Throwable throwable, boolean bl) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        if (bl) {
            throw new BuildException(string, throwable);
        }
        this.log("Error: " + string, 0);
    }

    public boolean isStandardLoader(int n) {
        if (this.isReference()) {
            return this.getRef().isStandardLoader(n);
        }
        if (this.loaderRef != null) {
            return false;
        }
        if (this.loader != null) {
            return this.loader.getIndex() == n;
        }
        return false;
    }

    public boolean equalsSysLoader() {
        if (this.isReference()) {
            return this.getRef().equalsSysLoader();
        }
        if (this.loaderRef == null && this.loader != null && (this.loader.getIndex() == 0 || this.loader.getIndex() == 5 || this.loader.getIndex() == 1)) {
            return true;
        }
        ClassLoader classLoader = this.getClassLoader(null);
        if (classLoader == null) {
            return false;
        }
        ClassLoader classLoader2 = new LoaderSpec(LoaderSpec.MAGIC_NAMES[0]).getClassLoader(this);
        if (classLoader2 == classLoader) {
            return true;
        }
        classLoader = new LoaderSpec(LoaderSpec.MAGIC_NAMES[5]).getClassLoader(this);
        if (classLoader2 == classLoader) {
            return true;
        }
        classLoader = new LoaderSpec(LoaderSpec.MAGIC_NAMES[1]).getClassLoader(this);
        return classLoader2 == classLoader;
    }

    public boolean isResetPossible() {
        if (this.isReference()) {
            return this.getRef().isResetPossible();
        }
        if (this.loaderRef != null) {
            return true;
        }
        if (this.loader != null) {
            return this.loader.isResetPossible();
        }
        return false;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.isReference()) {
            this.getRef().setClassLoader(classLoader);
        } else if (this.loaderRef != null) {
            this.getProject().addReference(this.loaderRef, (Object)classLoader);
        } else if (this.loader != null) {
            this.loader.set(this, classLoader);
        }
    }

    public void setFailonerror(boolean bl) {
        this.checkAttributesAllowed();
        this.failOnError = bl;
    }

    public void setLoader(LoaderSpec loaderSpec) {
        this.checkAttributesAllowed();
        this.loader = loaderSpec;
    }

    public void setLoaderRef(Reference reference) {
        this.checkAttributesAllowed();
        String string = reference.getRefId();
        for (int i = 0; i < LoaderSpec.MAGIC_NAMES.length; ++i) {
            if (!string.equals(LoaderSpec.MAGIC_NAMES[i])) continue;
            this.setLoader(new LoaderSpec(new LoaderSpec().getValues()[i]));
            return;
        }
        this.loaderRef = reference.getRefId();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LoaderSpec
    extends EnumeratedAttribute {
        public static final int CORE = 0;
        public static final int SYSTEM = 1;
        public static final int CURRENT = 2;
        public static final int NONE = 3;
        public static final int THREAD = 4;
        public static final int PROJECT = 5;
        public static final String[] MAGIC_NAMES = new String[]{"ant.coreLoader", null, null, null, null, null};

        public LoaderSpec() {
        }

        public LoaderSpec(String string) {
            this.setValue(string);
        }

        public ClassLoader getClassLoader(LoaderRef loaderRef) {
            switch (this.getIndex()) {
                case 0: {
                    return loaderRef.getProject().getCoreLoader();
                }
                case 1: {
                    return ClassLoader.getSystemClassLoader();
                }
                case 2: {
                    return ((Object)((Object)loaderRef)).getClass().getClassLoader();
                }
                case 4: {
                    return Thread.currentThread().getContextClassLoader();
                }
                case 5: {
                    return loaderRef.getProject().getClass().getClassLoader();
                }
            }
            return null;
        }

        public ClassLoader getClassloaderOrFallback(LoaderRef loaderRef) {
            switch (this.getIndex()) {
                case 0: {
                    ClassLoader classLoader = loaderRef.getProject().getCoreLoader();
                    if (classLoader != null) {
                        return classLoader;
                    }
                    return new LoaderSpec("PROJECT").getClassloaderOrFallback(loaderRef);
                }
            }
            return this.getClassLoader(loaderRef);
        }

        public boolean isResetPossible() {
            switch (this.getIndex()) {
                case 0: 
                case 4: {
                    return true;
                }
            }
            return MAGIC_NAMES[this.getIndex()] != null;
        }

        public void set(LoaderRef loaderRef, ClassLoader classLoader) {
            switch (this.getIndex()) {
                case 4: {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    break;
                }
                case 0: {
                    loaderRef.getProject().setCoreLoader(classLoader);
                    break;
                }
            }
            if (MAGIC_NAMES[this.getIndex()] != null) {
                loaderRef.getProject().addReference(MAGIC_NAMES[this.getIndex()], (Object)classLoader);
            }
        }

        public String[] getValues() {
            return new String[]{"core", "system", "current", "none", "thread", "project"};
        }

        public String toString() {
            switch (this.getIndex()) {
                case 0: {
                    return "CoreLoader";
                }
                case 1: {
                    return "SystemClassLoader";
                }
                case 2: {
                    return "Current ClassLoader";
                }
                case 4: {
                    return "ThreadContextClassLoader";
                }
                case 5: {
                    return "ProjectClassLoader";
                }
            }
            return null;
        }
    }
}

