/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Map;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApnsFeedbackConnection {
    private static final Logger logger = LoggerFactory.getLogger(ApnsFeedbackConnection.class);
    private final SocketFactory factory;
    private final String host;
    private final int port;
    int DELAY_IN_MS = 1000;
    private static final int RETRIES = 3;

    public ApnsFeedbackConnection(SocketFactory factory, String host, int port) {
        this.factory = factory;
        this.host = host;
        this.port = port;
    }

    public Map<String, Date> getInactiveDevices() throws NetworkIOException {
        int attempts = 0;
        while (true) {
            try {
                ++attempts;
                Map<String, Date> result = this.getInactiveDevicesImpl();
                attempts = 0;
                return result;
            }
            catch (Exception e) {
                logger.warn("Failed to retreive invalid devices", (Throwable)e);
                if (attempts >= 3) {
                    logger.error("Couldn't get feedback connection", (Throwable)e);
                    Utilities.wrapAndThrowAsRuntimeException(e);
                }
                Utilities.sleep(this.DELAY_IN_MS);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Date> getInactiveDevicesImpl() throws IOException {
        Map<String, Date> map;
        Socket socket = null;
        try {
            socket = this.factory.createSocket(this.host, this.port);
            InputStream stream = socket.getInputStream();
            map = Utilities.parseFeedbackStream(stream);
        }
        catch (Throwable throwable) {
            Utilities.close(socket);
            throw throwable;
        }
        Utilities.close(socket);
        return map;
    }
}

