package it.softecspa.sso.client;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;
import it.softecspa.sso.LogCategory;
import it.softecspa.sso.common.SsoErrorOutcome;
import it.softecspa.sso.common.SsoException;
import it.softecspa.sso.common.TokenInfo;
import it.softecspa.sso.common.remote.TokenInfoResponse;

import java.io.Serializable;

import org.apache.log4j.Logger;


@SuppressWarnings("serial")
public class AuthStatus implements Serializable {
	
	private Logger log = Logger.getLogger(LogCategory.SSO_LOG_CATEGORY);
	
	static final int NO_STEP 			= 0;
	
	static final int GET_AUTH_CODE 		= 11;
	static final int ACQUIRE_TOKEN		= 12;
	static final int GET_TOKEN_INFO		= 13;
	static final int INVALIDATE_TOKEN	= 14;
	
	static final int FINISH				= 10;
	
	static final int JUMP_OPERATION		= 98;
	static final int REDIRECT			= 99;
		
	// https://developers.google.com/accounts/docs/OAuth2Login
	
	
	
	
	private Step step;
	private String state;
	private String code;	
	//
	private AccessToken token;
	private TokenInfo tokenInfo;
	private String scopeString;
	private String organization;
	private EnterpriseCalendar expires;
	// 
	private boolean logged;
	
	// Stato della autenticazione
	private SsoErrorOutcome lastSsoStatus;
	private String lastSsoStatusMessage;
	
	
	AuthStatus() {
		this.step = Step.NO_STEP;
		this.token = AccessToken.NULL();
		this.logged = false;
		this.lastSsoStatus = SsoErrorOutcome.NOT_LOGGED;
	}
	
	
	public Step getStep() {
		return step;
	}

	void setStep(Step step) {
		this.step = step;
	}

	String getCode() {
		return code;
	}

	void setCode(String code) {
		this.code = code;
	}

	
	
	/**
	 * Recupero lo step di avanzamento in base ale condizioni dello statu
	 * @return
	 */
	Step autoNextStep() {
		
		// Sono gi loggato, non faccio niente
		if (logged) {
			step = Step.JUMP_OPERATION;
			return step;
		}

		// Possiedo un token valido
		if (token.isValid()) {
			step = Step.GET_TOKEN_INFO;
			return step;
		}	
		
		// Possiedo un authorization code
		if (code!=null) {
			step = Step.ACQUIRE_TOKEN;
			return step;
		}
		
		// Richiesdo un codice di autorizzazione
		step = Step.GET_AUTH_CODE;
		return step;
	}


	public AccessToken getToken() {
		return token;
	}


	void setToken(AccessToken token) {
		this.token = token;
	}

	void setLogged(boolean logged) {
		this.logged = logged;
	}
	
	public boolean isLogged() {
		return logged;
	}


	public void validateNextStep(AbstractHttpSsoController controller, Step next_step) throws SsoException {
		if (log.isDebugEnabled()) log.debug("SSO - Validate next step: "+next_step+" ("+next_step.getValue()+")");
		this.step = next_step;
		
		if (next_step==Step.NO_STEP) {
			this.lastSsoStatus = SsoErrorOutcome.NOSTATE_STEP_NOT_VALID;
			throw new SsoException(this.lastSsoStatus, next_step+" -> "+next_step);
		}	
		
		if (next_step==Step.GET_AUTH_CODE) {
			if (XString.isNotBlankNullTrim(code)) {
				this.lastSsoStatus = SsoErrorOutcome.AUTHCODE_PRESENT;
				throw new SsoException(this.lastSsoStatus,"Step "+next_step);
			}
			this.code = null;
			controller.invalidateToken();			
		}
		
		if (next_step==Step.ACQUIRE_TOKEN) {
			if (XString.isBlankNullTrim(code)) {
				this.lastSsoStatus = SsoErrorOutcome.AUTHCODE_REQUIRED;
				throw new SsoException(this.lastSsoStatus,"Step "+next_step);
			}
			controller.invalidateToken();
		}
		
		if (next_step==Step.GET_TOKEN_INFO) {
			if (!token.isValid()) {
				this.lastSsoStatus = SsoErrorOutcome.ACCESS_TOKEN_REQUIRED;
				throw new SsoException(this.lastSsoStatus,"Step "+next_step);
			}
		}
		
		if (next_step==Step.INVALIDATE_TOKEN) {
			/*
			if (!token.isValid()) {
				this.lastSsoStatus = SSOOutcome.TOKEN_REQUIRED;
				throw new SSOException(this.lastSsoStatus,"Step "+next_step);
			}
			*/
		}
				
	}

	
	String getScopeString() {
		return scopeString;
	}

	void setScopeString(String scopeString) {
		this.scopeString = scopeString;
	}


	public String[] getScope() {
		return scopeString.split(",");
	}
	
	public String getState() {
		return state;
	}


	public void setState(String state) {
		this.state = state;
	}


	public String getOrganization() {
		return organization;
	}

	void setOrganization(String organization) {
		this.organization = organization;
	}


	


	public String getStatusCode() {
		return this.lastSsoStatus.getReturnCode();
	}

	public String getStatusMessage() {
		return this.lastSsoStatus.getMessage() + (this.lastSsoStatusMessage!=null?": "+this.lastSsoStatusMessage:"");
	}
	
	SsoErrorOutcome getLastSsoStatus() {
		return lastSsoStatus;
	}

	void setLastSsoStatus(SsoErrorOutcome status) {
		setLastSsoStatus(status, null);
	}
	
	void setLastSsoStatus(SsoErrorOutcome status, String message) {
		this.lastSsoStatus = status;
		this.lastSsoStatusMessage = message;
	}

	public void invalidateToken() {
		if (log.isDebugEnabled()) log.debug("SSO - Invalidate token!");
		this.token.invalidate();
		this.logged = false;		
	}


	public EnterpriseCalendar getExpires() {
		return expires;
	}

	void setExpires(EnterpriseCalendar expires) {
		this.expires = expires;
	}


	public TokenInfo getTokenInfo() {
		return tokenInfo;
	}

	void setTokenInfo(TokenInfoResponse tokenInfo) {
		this.tokenInfo = tokenInfo;
	}

	
}
