package it.softecspa.sso.client;


import it.softecspa.kahuna.net.SafeHttpURLConnection;
import it.softecspa.sso.LogCategory;
import it.softecspa.sso.common.remote.ErrorResponse;
import it.softecspa.sso.common.remote.SsoResponse;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.simple.parser.ParseException;

public class HttpSsoConnection {
	
	private static final String UTF8 = "UTF-8";
	
	public enum Method {
		POST, GET;
	}
	
	private Logger log = Logger.getLogger(LogCategory.SSO_LOG_CATEGORY);
	
	private String authorization;
	private Method method;
	private String url;
	//private HttpURLConnection connection;
	private Map<String,String> attributes;
	
	private int httpResponse;
	private SsoResponse response;
	
	
	
	
	public HttpSsoConnection (String url) throws MalformedURLException  {
		this.url = url;
		this.attributes = new HashMap<String,String>();
	}

	/**
	 * Setup del metodo di chiamata della request
	 * @param method
	 * @throws ProtocolException
	 */
	public void setRequestMethod(Method method) throws ProtocolException {
		this.method = method;
	}

	/**
	 * Imposta la variabile header 'Authorization'
	 * @param auth
	 */
	public void setAuthorization(String auth) {
		this.authorization = auth;		
	}

	/**
	 * Aggiunge un attributo d a passare nella chiamata
	 */
	public void setAttribute(String key, String value) {
		attributes.put(key, (value!=null?value:""));		
	}
	
	/**
	 * Aggiunge un attributo d apassare nella chiamata solo se diverso da NULL
	 */
	public void setAttributeNVL(String key, String value) {
		if (value==null) return;
		attributes.put(key, value);		
	}

	
	/**
	 * Esegue la chiamata remota e recupere la risposta
	 * @throws IOException 
	 * @throws ParseException 
	 */
	public boolean call(SsoResponse response) throws IOException, ParseException {
		// ------------------------------------------
		String param_body="";
		for (String key : attributes.keySet()) {
			param_body += (param_body.length()==0?"":"&")+key+"="+URLEncoder.encode(attributes.get(key),"UTF-8");
		}
		// ------------------------------------------
		
		
		URL url = null;
		if (method == Method.GET) {
			url = new URL(this.url+(param_body.length()==0?"":("?"+param_body)));
		} else if (method == Method.POST) {
			url = new URL(this.url);
		}
		if (log.isTraceEnabled()) log.trace("SSO - Call server to request token (method "+method.toString()+"): '"+url.toString()+"'");
	
		
		SafeHttpURLConnection connection = new SafeHttpURLConnection(url);
		connection.setRequestMethod(method.toString());
		
		// Setup HEADER
		if (Method.POST == method) {
			connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
		}
		if (authorization!=null) {
			if (log.isTraceEnabled()) log.trace("SSO - Authorization = '"+authorization+"'");
			connection.setRequestProperty("Authorization", authorization);
		}
		
		//DataOutputStream output = null;
		DataInputStream input = null; 
		//
		connection.setDoOutput(true); 
		connection.setDoInput(true); 
		connection.setAllowUserInteraction(true);
		if (log.isDebugEnabled()) log.debug("SSO - Execute remote call to server, in progress....");
		try {
			//connection.connect();
			if (method == Method.POST) {
				/*
				output = new DataOutputStream(connection.getOutputStream());  
				if (log.isTraceEnabled()) log.trace("SSO - Body: "+param_body);
				output.write(param_body.getBytes("UTF-8"));
				output.close();
				*/
				connection.write(param_body.getBytes("UTF-8"));
			}
			httpResponse = connection.getResponseCode();
		} catch (IOException e) {
			throw e;
		} finally {
			/*
			if (output!=null) {
				try {
					output.close();
				} catch (Exception e) {
					/ * Nessuna operazione* /
				}
			}
		 	*/
		}
	
		if (log.isDebugEnabled()) log.debug("SSO - Waiting response from server, in progress....");
		try {
			InputStream inputStream = null;
			if (httpResponse >= 400) {
				inputStream = connection.getErrorStream();  
			} else {
				inputStream = connection.getInputStream();  
			}
			input = new DataInputStream(inputStream);
			
			if (httpResponse >= 400) {
				this.response  = new ErrorResponse();
				this.response.setResponseCode(connection.getResponseCode());
				this.response.setResponseMessage(connection.getResponseMessage());
				try {
					this.response.parse(input);
				} catch (Exception e) {
					/* Nessun controllo */
				}
			}  else {
				this.response = response;
				this.response.setResponseCode(connection.getResponseCode());
				this.response.setResponseMessage(connection.getResponseMessage());
				this.response.parse(input);				
			}
			
			
		} catch (IOException e) {
			throw e;
		}
				
		if (log.isDebugEnabled()) log.debug("SSO - Request completed!");
		if (httpResponse >= 400 || httpResponse==0) {
			return false;
		} else {
			return true;
		}
	}

	
	public SsoResponse getResponse() {
		return response;
	}

	public int getHttpResponse() {
		return httpResponse;
	}
	
	public String encodeBase64(String clientId, String secret) throws UnsupportedEncodingException {
		if (log.isTraceEnabled()) {
			log.trace("Encode base64 UTF8 bytes of clientId = '"+clientId+"' and secret = '"+secret+"'");
		}
		return new String(Base64.encodeBase64((clientId+":"+secret).getBytes(UTF8)));
	}
	
	public String encodeBase64(String signature) throws UnsupportedEncodingException {
		if (log.isTraceEnabled()) {
			log.trace("Encode base64 UTF8 bytes of signature = '"+signature+"'");
		}
		return new String(Base64.encodeBase64(signature.getBytes(UTF8)));
	}
	
	
}
