package it.softecspa.sso.client;

import it.softecspa.sso.common.SsoException;
import it.softecspa.sso.common.UserInfo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class HttpSsoController extends AbstractHttpSsoController {

	public HttpSsoController(HttpClientSetting config) throws SsoException {
		super(config);
	}

	/**
	 * Esegue in automaticol la procedura di login
	 * @param request
	 * @param response
	 * @return
	 * @throws SsoException
	 */
	public AuthStatus accessCheck(HttpServletRequest request, HttpServletResponse response) throws SsoException {
		return executeStep(Step.NO_STEP, request, response);
	}
	
	
	/**
	 * Validazione del token passato nella variabile 'access_token' 
	 * @param request
	 * @param response
	 * @return
	 * @throws SsoException
	 */
	public AuthStatus validateAccessToken(HttpServletRequest request, HttpServletResponse response) throws SsoException {
		return executeStep(Step.GET_TOKEN_INFO, request, response);
	}

	
	/**
	 * Invalida lo user token ed esegue il logout
	 * @param request
	 * @param response
	 * @throws SsoException
	 */
	public void revokeToken(HttpServletRequest request, HttpServletResponse response) throws SsoException {
		executeStep(Step.INVALIDATE_TOKEN, request, response);
	}

	
	public SsoStub getSsoStub() {
		return super.stub;
	}
		
	/**
	 * Recupera le informazioni utente
	 * @return
	 * @throws SsoException
	 */
	public UserInfo acquireUserInfo() throws SsoException {
		return super.stub.acquireUserInfo(authStatus.getToken().getValue());
	}
	
	/**
	 * Esegue il cambio password
	 * @param old_password
	 * @param new_pasword
	 * @throws SsoException
	 */
	public void changePassword(String old_password, String new_password ) throws SsoException {
		super.stub.changePassword(authStatus.getToken().getValue(), authStatus.getOrganization(), authStatus.getToken().getName(),  old_password, new_password);
	}
	
}
