package it.softecspa.sso.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/**
 * Elemento contenitore delle informazioni aggiuntive legate alla richiesta di login
 */
public class Additional {

	private Map<String,String> entries;
	
	public Additional() {
		this.entries = new HashMap<String,String>();
	}

	public void addEntry(String key, String value) {
		this.entries.put(key, value);
	}
	
	public Collection<String> getEntries() {
		return entries.values();
	}

	
	public String toJson() {
		if (isEmpty()) return null;
		
		String s = "";
		for (String key : entries.keySet()) {
			String value = entries.get(key);
			if (value!=null) {
				s+= (s.length()>0?",":"") 
				  + "\"" + key + "\":\"" + value + "\"";
			}
		}
		return "{"+s+"}";
	}

	
	public boolean isEmpty() {
		return this.entries.isEmpty();
	}
	
	/**
	 * @exception NullPointerException
	 * @exception ParseException
	 * @exception 
	 * @param value
	 * @return
	 * @throws Exception 
	 */
	public static Additional parseString(String value) throws Exception {
		if (value==null) throw new NullPointerException();
		
		JSONParser parser = new JSONParser();
		JSONObject jsonObject;
		try {
			jsonObject = (JSONObject)parser.parse(value);
		} catch (ParseException e) {
			throw new Exception("Error parsing additional json",e);
		}
		
		Additional additional = new Additional();
		for (Object key : jsonObject.keySet()) {
			additional.entries.put((String)key, (String)jsonObject.get(key));
		}
		return additional;
		
	}
	
}
