package it.softecspa.sso.common;

public class Entry {

	private String key;	
	private String value;
	
	public Entry(String key, String value) {
		this.key = key;
		this.value = value;
	}
	
	public Entry(String key, Integer value) {
		this.key = key;
		this.value = (value!=null?value.toString():null);
	}

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}
	
	@Override
	public String toString() {
		return key + "=" + (value!=null?"'"+value+"'":"");
	}
	
	public String toJson() {
		return "\""+key+"\":\""+(value!=null?value:"")+"\"";
	}
	
}
