package it.softecspa.sso.common;

public enum SsoErrorOutcome {
		  ERROR								(79999,"SSO request error")		
		
		//
		, FIELD_MANDATORY					(90401,"Error checking configuration, field is mandatory")
		, FIELD_EMPTY						(90402,"Error checking configuration, field is empty (not valid empty string)")
		, FIELD_OUT_OF_RANGE				(90403,"Error checking configuration, field is out of range")
		, FIELD_NOT_VALID					(90404,"Error checking configuration, field is not valid")
		, FIELD_OVERFLOW					(90405,"Error checking configuration, field is in overflow")
		//
		, INVALID_METHOD_CHECKING			(90408,"Error checking configuration, invalid method checking")
		
		//
		, STEP_NOT_VALID					(70000,"Step is not valid")
		, STEP_IS_NULL						(70001,"Step is null, check configuration")
		, NOSTATE_STEP_NOT_VALID			(70002,"Step sequence is not valid")
		, AUTHCODE_REQUIRED					(70003,"Step sequence not valid, authorization code required")
		, AUTHCODE_PRESENT					(70004,"Step sequence not valid, authorization code is present")
		, ACCESS_TOKEN_REQUIRED				(70005,"Step sequence not valid, access token required")
		, SEND_REDIRECT_ERROR				(70006,"Error in redirect page")
		, SEND_REDIRECT_ERROR_PAGE			(70007,"Error in redirect to erroro page")
		, SCOPE_IS_NULL						(70008,"Scope is null, check configuration")
		, CODE_IS_NULL						(70009,"Authorization code is null, check sequence")
		, REMOTE_CALL_ERROR					(70010,"Remote call error")
		, UNHANDLED_EXCEPTION				(70011,"Unhandled exception")
		, GET_TOKEN_INFO_ERROR				(70012,"Error get token info (token validation)")
		, GET_USER_INFO_ERROR				(70013,"Error get user info")
		, CHANGE_PASSWORD_ERROR				(70014,"Error in change password")
		, LOGOUT_ERROR						(70015,"Error in logout")		
		, USERNAME_REQUIRED					(70016,"Username required")
		, PASSWORD_REQUIRED					(70017,"Password required")
		, ORGANIZATION_REQUIRED				(70018,"Organization required")
		, NEW_PASSWORD_REQUIRED				(70019,"New pasword required")
		, WRONG_CREDENTIAL					(70020,"Wrong credential")
		
		
		// Esito positivo (CLASSE 0)
		, NOT_LOGGED						(666,"Not logged")
		, OK_AUTHORIZATION_CODE				(10,"Authorization_code")
		, OK_ACQUIRED_TOKEN					(20,"Acquired token")
		, OK_VALIDATED_TOKEN				(30,"Validated token")
		, OK_LOGGED							(0,"Logged and validate token")
		
		;
		  
	
		
	private int id;	  
	private String code;
	private String message;
	
	private SsoErrorOutcome(int id, String message) {
		this.id = id;
		this.code = Integer.toString(id);
		this.message = message;
	}
	
	public String getReturnCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public int getId() {
		return id;
	}
	
	
	public String getFullMessage() {
		return "("+id+") "+message;
	}

		
}
