package it.softecspa.sso.common;

import it.softecspa.kahuna.lang.XString;

@SuppressWarnings("serial")
public class SsoException extends Throwable {

	private String id;

	public SsoException(SsoErrorOutcome outcome) {
		this(outcome.getReturnCode(), outcome.getMessage(), null);
	}

	public SsoException(SsoErrorOutcome outcome, Throwable e) {
		this(outcome.getReturnCode(), outcome.getMessage(), e);
	}
	
	public SsoException(SsoErrorOutcome outcome, String add_message) {
		this(outcome.getReturnCode(), outcome.getMessage() + XString.toString(" [" + add_message + "]"), null);
	}
	
	public SsoException(SsoErrorOutcome outcome, String add_message, Throwable e) {
		this(outcome.getReturnCode(), outcome.getMessage() + XString.toString(" [" + add_message + "]"), e);
	}
	
	private SsoException(String id, String message, Throwable e) {
		super(message, e);
		this.id = id;
	}

	public String getId() {
		return id;
	}

}
