package it.softecspa.sso.common;

import java.io.Serializable;

@SuppressWarnings("serial")
public abstract class Token implements Serializable {

	protected String value;
	protected Long expireIn;
	//
	protected String name;

	
	protected Token() {
		invalidateMe();
	}
	
	/**
	 * Invalida il token impostando i valori di default
	 */
	protected void invalidateMe() {
		this.value = null;	
		this.expireIn = 0L;
		this.name = null;
	}
	
	protected Token(String value, Long expireIn) {
		this.value = value;
		this.expireIn = expireIn;
		this.name = null;
	}
	
	public String getValue() {
		return value;
	}
	
	public boolean isValid() {
		if (value==null) return false;
		return true;
	}

	public Long getExpireIn() {
		return expireIn;
	}

	public String getName() {
		return name;
	}

	
	
}
