package it.softecspa.sso.common.remote;

import java.io.DataInputStream;
import java.io.IOException;

import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class AcquireTokenResponse extends SsoResponse {

	// {"scope":"userinfo","access_token":"4bc75781-e354-4e3c-892e-e32ed9feddcb","token_type":"bearer","expires_in":1209600}Resp Code:200
		
	private String scope;
	private String accessToken;
	private String tokenType;	
	private Long expiresIn;
	
	@Override
	public void parse(DataInputStream input) throws ParseException, IOException {
		
		JSONObject jsonObject = parseInput(input);
		// {"scope":"userinfo","access_token":"4bc75781-e354-4e3c-892e-e32ed9feddcb","token_type":"bearer","expires_in":1209600}
		scope = (String) jsonObject.get("scope");
		accessToken = (String) jsonObject.get("access_token");
		tokenType = (String) jsonObject.get("token_type");
		expiresIn = (Long) jsonObject.get("expires_in");
	}


	public String getScope() {
		return scope;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public String getTokenType() {
		return tokenType;
	}

	public Long getExpiresIn() {
		return expiresIn;
	}
	
}
