package it.softecspa.sso.common.remote;

import java.io.DataInputStream;
import java.io.IOException;

import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class ErrorResponse extends SsoResponse {
	
	private String error;
	private String errorDescription;
	
	@Override
	public void parse(DataInputStream input) throws ParseException, IOException {
		JSONObject jsonObject = parseInput(input);
		// {"error":"unsupported_grant_type","error_description":"The supported grant_type values are 'authorization_code', 'refresh_token' and 'password'"}
		error = (String) jsonObject.get("error");
		errorDescription = (String) jsonObject.get("error_description");
	}

	public String getError() {
		return error;
	}

	public String getErrorDescription() {
		return errorDescription;
	}

}
