package it.softecspa.sso.common.remote;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;


public abstract class SsoResponse {

	protected Logger log = Logger.getLogger(getClass());
	protected int responseCode;
	protected String responseMessage;
	
	
	public int getResponseCode() {
		return responseCode;
	}
	
	public void setResponseCode(int responseCode) {
		this.responseCode = responseCode;
	}
	
	public String getResponseMessage() {
		return responseMessage;
	}
	
	public void setResponseMessage(String responseMessage) {
		this.responseMessage = responseMessage;
	}
	
	
	public abstract void parse(DataInputStream input) throws ParseException, IOException;
	
	
	String readline(DataInputStream input) throws IOException {
		String readline = "";
		for( int c = input.read(); c != -1; c = input.read() ) {
			readline += ( (char)c ); 
		}
		return readline;
	}
	
	JSONObject parseInput(DataInputStream input) throws ParseException, IOException {
		JSONParser parser = new JSONParser();
		Object obj = parser.parse(readline(input));
		return (JSONObject) obj;
	}
	
	
	<K> List<K> castArray(JSONArray jsonArray) {
		if (jsonArray==null) return null;
		List<K> ret = new ArrayList<K>();
		for (@SuppressWarnings("unchecked")
		Iterator<K> i = jsonArray.iterator(); i.hasNext();) {
			ret.add(i.next());
		}
		return ret;
	}
	
}
