package it.softecspa.sso.common.remote;

import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;
import it.softecspa.sso.common.TokenInfo;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class TokenInfoResponse extends SsoResponse implements TokenInfo {
	
	private String accessToken;
	private String audience;
	private List<String> roles;
	private List<String> scopes;
	private Map<String, String> attributes;	
	private String name;
	private EnterpriseCalendar expires;
	
	
	public TokenInfoResponse(String value) {
		this.accessToken = value;
	}

	@SuppressWarnings("unchecked")
	public void parse(DataInputStream input) throws ParseException, IOException {
		JSONObject jsonObject = parseInput(input);
		// {"scopes":["userinfo"],"audience":"DM Service","principal":{"roles":[],"name":"ilvera","attributes":{"organization":"SOFTEC"}},"expires_in":1363853135604}
	
		audience = (String)jsonObject.get("audience");
		scopes = castArray((JSONArray)jsonObject.get("scopes"));
		try {
			expires = EnterpriseCalendar.newInstance((String)jsonObject.get("expires"), EnterpriseCalendar.PATTERNS_UTC);
		} catch (Exception e) {
			log.warn("Error parsing token expire date:" +e.toString());
		}
		JSONObject jsonPrincipal = (JSONObject)jsonObject.get("principal");
		roles = castArray((JSONArray)jsonPrincipal.get("roles"));
		name = (String)jsonPrincipal.get("name");		
		JSONObject jsonAttributes = (JSONObject)jsonPrincipal.get("attributes");
		
		attributes = new HashMap<String,String>();
		if (jsonAttributes!=null) {
			attributes.putAll(jsonAttributes);
		}
	}

	@Override
	public String getAudience() {
		return audience;
	}

	@Override
	public List<String> getRoles() {
		return roles;
	}

	@Override
	public List<String> getScopes() {
		return scopes;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public EnterpriseCalendar getExpires() {
		return expires;
	}

	@Override
	public Map<String, String> getAttributes() {
		return attributes;
	}

	@Override
	public String getAccessToken() {
		return accessToken;
	}


	
}
