package it.softecspa.sso.common.remote;

import it.softecspa.sso.common.UserInfo;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class UserInfoResponse extends SsoResponse implements UserInfo {
	
	private String username;
	private String givenName;	
	private String familyName;
	private String email;
	private String birthdate;
	private String gender;
	private String pictureUrl;
	private List<String> roles;
	
	@Override
	public void parse(DataInputStream input) throws ParseException, IOException {
		JSONObject jsonObject = parseInput(input);
		/*
			 {
			    "id": ...,
			    "creationDate": ...,
			    "modificationDate": ...,
			    "username": ...,
			    "password": ,
			    "givenName": ...,
			    "familyName": ...,
			    "email": ...,
			    "birthdate": ...,
			    "gender": ...,
			    "pictureUrl": ...
			 } 
		 */
		username = (String)jsonObject.get("username");
		givenName = (String)jsonObject.get("givenName");
		familyName = (String)jsonObject.get("familyName");
		email = (String)jsonObject.get("email");
		pictureUrl = (String)jsonObject.get("pictureUrl");
		gender = (String)jsonObject.get("gender");
		birthdate = (String)jsonObject.get("birthdate");
		roles = castArray((JSONArray)jsonObject.get("roles"));
	}

	@Override
	public String getUsername() {
		return username;
	}

	@Override
	public String getGivenName() {
		return givenName;
	}

	@Override
	public String getFamilyName() {
		return familyName;
	}

	@Override
	public String getEmail() {
		return email;
	}

	@Override
	public String getPictureUrl() {
		return pictureUrl;
	}
	
	@Override
	public List<String> getRoles() {
		return roles;
	}

	public String getBirthdate() {
		return birthdate;
	}

	public String getGender() {
		return gender;
	}

}
