package it.softecspa.sso.proxy;

import it.softecspa.sso.common.SsoErrorOutcome;

import java.io.Serializable;


@SuppressWarnings("serial")
public class Authorization implements Serializable {
	
	private StubCall call;
	private AccessToken token;
	private String[] scope;
	private String organization;
	//
	private boolean logged;
	
	// Stato della autenticazione
	private SsoErrorOutcome lastSsoStatus;
	private String lastSsoStatusMessage;
	
	
	Authorization() {
		this.call = StubCall.NO_CALL;
		this.token = AccessToken.NULL();
		this.logged = false;
		this.lastSsoStatus = SsoErrorOutcome.NOT_LOGGED;
	}
	
	
	public StubCall getCall() {
		return call;
	}

	void setCall(StubCall call) {
		this.call = call;
	}

	public AccessToken getToken() {
		return token;
	}

	void setAccessToken(AccessToken token) {
		this.token = token;
	}

	void setLogged(boolean logged) {
		this.logged = logged;
	}
	
	public boolean isLogged() {
		return logged;
	}

	
	public String[] getScope() {
		return scope;
	}


	void setScope(String[] scope) {
		this.scope = scope;
	}

	public String getOrganization() {
		return organization;
	}

	void setOrganization(String organization) {
		this.organization = organization;
	}


	public String getStatusCode() {
		return this.lastSsoStatus.getReturnCode();
	}

	public String getStatusMessage() {
		return this.lastSsoStatus.getMessage() + (this.lastSsoStatusMessage!=null?": "+this.lastSsoStatusMessage:"");
	}
	
	SsoErrorOutcome getLastSsoStatus() {
		return lastSsoStatus;
	}

	void setLastSsoStatus(SsoErrorOutcome status) {
		setLastSsoStatus(status, null);
	}
	
	void setLastSsoStatus(SsoErrorOutcome status, String message) {
		this.lastSsoStatus = status;
		this.lastSsoStatusMessage = message;
	}

	
}
