package it.softecspa.sso.proxy;

import it.softecspa.sso.common.Additional;
import it.softecspa.sso.common.SsoException;
import it.softecspa.sso.common.TokenInfo;
import it.softecspa.sso.common.UserInfo;


public class ProxySsoStub extends AbstractProxySsoStub {

	public ProxySsoStub(ProxedClientSetting config) throws SsoException {
		super(config);
	}

	/**
	 * Esegue la login utilizzando tutti i parametri presenti nella configurazione
	 * @param username utente 
	 * @param password
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String username, String password) throws SsoException {
		return super.login(null, username, password, (String)null, null);
	}
	
	/**
	 * Esegue la login utilizzando i parametri di configurazione aggiungendo dei valori addizionali a quelli eventualmenti gi presenti
	 * @param username
	 * @param password
	 * @param additional
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String username, String password, Additional additional) throws SsoException {
		return super.login(null, username, password, additional, null);
	}
	
	
	/**
	 * Esegue la login utilizzando i parametri di configurazione, ma sovrascrivendo l'organizzazione presente
	 * @param organization
	 * @param username
	 * @param password
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String organization, String username, String password) throws SsoException {
		return super.login(organization, username, password, (String)null, null);
	}
	
	/**
	 * Esegue la login utilizzando i parametri di configurazione, sovrascrivendo l'organizzazione presente
	 * e aggiungendo dei valori addizionali a quelli eventualmenti gi presenti
	 * @param organization
	 * @param username
	 * @param password
	 * @param additional
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String organization, String username, String password, Additional additional) throws SsoException {
		return super.login(organization, username, password, additional, null);
	}
	
	/**
	 * Esegue la login utilizzando i parametri di configurazione, sovrascrivendo l'organizzazione presente
	 * e aggiungendo dei valori addizionali a quelli eventualmenti gi presenti
	 * @param organization
	 * @param username
	 * @param password
	 * @param jsonAdditional
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String organization, String username, String password, String jsonAdditional) throws SsoException {
		return super.login(organization, username, password, jsonAdditional, null);
	}
	
	/**
	 * Esegue la login utilizzando i parametri di configurazione, sovrascrivendo l'organizzazione presente
	 * e aggiungendo dei valori addizionali a quelli eventualmenti gi presenti
	 *  passato anche l'uthenticatorda forzare
	 * @param organization
	 * @param username
	 * @param password
	 * @param jsonAdditional
	 * @param authenticator
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String organization, String username, String password, String jsonAdditional, String authenticator) throws SsoException {
		return super.login(organization, username, password, jsonAdditional, authenticator);
	}
	
	
	/**
	 * Esegue la login utilizzando i parametri di configurazione, sovrascrivendo l'organizzazione presente
	 * e aggiungendo dei valori addizionali a quelli eventualmenti gi presenti
	 *  passato anche l'uthenticatorda forzare
	 * @param organization
	 * @param username
	 * @param password
	 * @param additional
	 * @param authenticator
	 * @return
	 * @throws SsoException
	 */
	public Authorization login(String organization, String username, String password, Additional additional, String authenticator) throws SsoException {
		return super.login(organization, username, password, additional, authenticator);
	}
	

	public void logout(String access_token) throws SsoException {
		super.logout(access_token);
	}
	
	public TokenInfo acquireTokenInfo(String access_token) throws SsoException {
		return super.acquireTokenInfo(access_token);
	}
	
	public UserInfo acquireUserInfo(String access_token) throws SsoException {
		return super.acquireUserInfo(access_token);
	}
	
	public void changePassword(String access_token, String organization, String username, String old_password, String new_password) throws SsoException {
		super.changePassword(access_token,organization, username, old_password, new_password);
	}
	
}
