/*
 * Created on 9-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.analyzer;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;
import it.softecspa.mvc.businessobject.User;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;

public class Dati extends UpdatableRow {

	Logger log = Logger.getLogger(getClass());
	
	private String sessionId = "";
	private String data = "";
	private String ip = "";
	private String user_agent = "";
	private String referer = "";
	private String username = "";
	private String profilo = "";
	private String servlet_name = "";
	private String servlet_code = "";
	private String request_params = "";
	private int n = 0;// <-- contenitore del count

	public Dati() {
	}

	public static Dati[] getDati() throws SQLException {
		String q = "SELECT * FROM cms_37_log_accessi WHERE processed IS NULL";
		return (Dati[]) (new Dati()).getRows(q);
	}

	// Accessi alle funzionalit
	public static int getContAcsFunz(String channel_id, String dataStart, String dataEnd) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE "
				+ ((channel_id == null) ? "request_params IS NULL " : "(request_params LIKE '%channel\\_id=" + channel_id + ",%' " + "OR request_params LIKE '%channel\\_id=" + channel_id + "') ") + "AND data BETWEEN '" + dataStart + "' AND '"
				+ dataEnd + "'";
		return getInt(q);
	}

	// Accessi alle funzionalit da interni
	public static int getContAcsFunz_int(String channel_id, String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE "
				+ ((channel_id == null) ? "request_params IS NULL " : "(request_params LIKE '%channel\\_id=" + channel_id + ",%' " + "OR request_params LIKE '%channel\\_id=" + channel_id + "') ") + "AND ip LIKE '" + internal_ip_mask + "' "
				+ "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi alle funzionalit da esterni
	public static int getContAcsFunz_est(String channel_id, String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE "
				+ ((channel_id == null) ? "request_params IS NULL " : "(request_params LIKE '%channel\\_id=" + channel_id + ",%' " + "OR request_params LIKE '%channel\\_id=" + channel_id + "') ") + "AND ip NOT LIKE '" + internal_ip_mask + "' "
				+ "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi ai contenuti da interni
	public static int getContAcsCnt_int(String cnt_id, String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE (request_params LIKE '%cnt\\_id=" + cnt_id + ",%' " + "OR request_params LIKE '%cnt\\_id=" + cnt_id + "') " + "AND ip LIKE '" + internal_ip_mask + "' "
				+ "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi ai contenuti da esterni
	public static int getContAcsCnt_est(String cnt_id, String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE (request_params LIKE '%cnt\\_id=" + cnt_id + ",%' " + "OR request_params LIKE '%cnt\\_id=" + cnt_id + "') " + "AND ip NOT LIKE '" + internal_ip_mask + "' "
				+ "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Utenti unici
	public static int getContUtUnici(String dataStart, String dataEnd) throws SQLException {
		String q = "SELECT COUNT(DISTINCT(ip)) AS n FROM cms_37_log_accessi " + "WHERE data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Utenti unici interni
	public static int getContUtUnici_int(String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(DISTINCT(ip)) AS n FROM cms_37_log_accessi " + "WHERE ip LIKE '" + internal_ip_mask + "' " + "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Utenti unici esterni
	public static int getContUtUnici_est(String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(DISTINCT(ip)) AS n FROM cms_37_log_accessi " + "WHERE ip NOT LIKE '" + internal_ip_mask + "' " + "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi utenti
	public static int getContAcsUtenti(String dataStart, String dataEnd) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi utenti interni
	public static int getContAcsUtenti_int(String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE ip LIKE '" + internal_ip_mask + "'" + "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi utenti esterni
	public static int getContAcsUtenti_est(String dataStart, String dataEnd, String internal_ip_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE ip NOT LIKE '" + internal_ip_mask + "'" + "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	// Accessi per user agent
	public static Dati[] getContAcsUserAgent(String dataStart, String dataEnd) throws SQLException {
		String q = "SELECT COUNT(*) AS n, user_agent FROM cms_37_log_accessi " + "WHERE data BETWEEN '" + dataStart + "' AND '" + dataEnd + "' " + "GROUP BY user_agent";
		return (Dati[]) (new Dati()).getRows(q);
	}

	// Accessi per user agent (parametrizzato nel file di properties)
	public static Dati[] getContAcsUserAgent(String dataStart, String dataEnd, String like) throws SQLException {
		// String q =
		// "SELECT COUNT(*) AS n, user_agent FROM cms_37_log_accessi " +
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE data BETWEEN '" + dataStart + "' AND '" + dataEnd + "' " + "AND (user_agent LIKE '" + like + "') ";
		return (Dati[]) (new Dati()).getRows(q);
	}

	public static int getContAcsUserAgentClick(String dataStart, String dataEnd) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE data BETWEEN '" + dataStart + "' AND '" + dataEnd + "' ";
		return getInt(q);
	}

	// Accessi da link esterni
	public static int getContAcsLink_est(String dataStart, String dataEnd, String local_referer_mask) throws SQLException {
		String q = "SELECT COUNT(*) AS n FROM cms_37_log_accessi " + "WHERE referer NOT LIKE '" + local_referer_mask + "'" + "AND referer NOT LIKE 'http://localhost%'" + "AND data BETWEEN '" + dataStart + "' AND '" + dataEnd + "'";
		return getInt(q);
	}

	protected void readRow(ResultSet rs) throws SQLException {
		try {
			n = rs.getInt("n");
		} catch (Exception e) {
			log.warn("Unhandled exception read ResultSet",e);
		}
		try {
			user_agent = rs.getString("user_agent");
			sessionId = rs.getString("sessionid");
			data = rs.getString("data");
			ip = rs.getString("ip");
			referer = rs.getString("referer");
			username = rs.getString("userid");
			profilo = rs.getString("id_profilo");
			servlet_name = rs.getString("servlet_name");
			servlet_code = rs.getString("servlet_code");
			request_params = rs.getString("request_params");
		} catch (Exception e) {
			log.warn("Unhandled exception read ResultSet",e);
		}
	}

	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		if (updateType == INSERT) {
			Query q = new Query("cms_37_log_accessi", true);

			q.addKeyFieldValue("sessionid", sessionId);
			q.addKeyFieldValue("data", data);
			q.addFieldValue("ip", ip);
			q.addFieldValue("user_agent", user_agent);
			q.addFieldValue("referer", referer);
			q.addFieldValue("userid", (User.UNKNWON_USERNAME.equals(username)) ? null : username);
			q.addFieldValue("id_profilo", profilo);
			q.addFieldValue("servlet_name", servlet_name);
			q.addFieldValue("servlet_code", servlet_code);
			q.addFieldValue("request_params", request_params);
			return dbs.execute(q.getQuery());
		} else if (updateType == UPDATE) {
			Query q = new Query("cms_37_log_accessi", false);

			q.addKeyFieldValue("sessionid", sessionId);
			q.addKeyFieldValue("data", data);
			q.addFieldValue("processed", format.format(new Date()));
			return dbs.execute(q.getQuery());
		} else {
			return 0;
		}
	}

	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getProfilo() {
		return profilo;
	}

	public void setProfilo(String profilo) {
		this.profilo = profilo;
	}

	public String getReferer() {
		return referer;
	}

	public void setReferer(String referer) {
		this.referer = referer;
	}

	public String getRequest_params() {
		return request_params;
	}

	public void setRequest_params(String request_params) {
		this.request_params = request_params;
	}

	public String getServlet_code() {
		return servlet_code;
	}

	public void setServlet_code(String servlet_cod) {
		this.servlet_code = servlet_cod;
	}

	public String getServlet_name() {
		return servlet_name;
	}

	public void setServlet_name(String servlet_name) {
		this.servlet_name = servlet_name;
	}

	public String getData() {
		return data;
	}

	public void setData(String time) {
		this.data = time;
	}

	public String getUser_agent() {
		return user_agent;
	}

	public void setUser_agent(String useragent) {
		this.user_agent = useragent;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public int getN() {
		return n;
	}

	public void setN(int n) {
		this.n = n;
	}
}
