/*
 * Created on 8-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.analyzer;

import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.portal.Parameters;
import it.softecspa.task.WebTimerTask;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

import javax.servlet.ServletConfig;

import org.apache.log4j.Logger;

/**
 * @author i.pezzino
 */
public class ImportLog extends WebTimerTask {

	private static Logger logger = Logger.getLogger(ImportLog.class);

	private String homeUrl = "";
	private String logDir = "";
	private String logFileBaseName = "";

	public ImportLog() {
	}

	protected void setConfig(ServletConfig config) {
		this.config = config;
	}

	protected void setParams() {
		Parameters parameters = Parameters.getInstance();

		this.homeUrl = params.get("JobImportLogHomeUrl") != null ? (String) params.get("JobImportLogHomeUrl") : parameters.get("base.url");
		this.logDir = params.get("accessLogDirectory") != null ? (String) params.get("accessLogDirectory") : "";
		this.logFileBaseName = params.get("logFileBaseName") != null ? (String) params.get("logFileBaseName") : "access.log";
	}

	@SuppressWarnings({ "rawtypes" })
	protected void doRun() throws Exception {
		this.isRunning = true;
		String url = this.homeUrl;
		String path = this.logDir;

		if (!path.endsWith("/"))
			path += "/";

		// Forzo un accesso oggi per costringere il log4j ad aggiornare i file di log
		LogClientHTTP ch = new LogClientHTTP(url);
		try {
			@SuppressWarnings("unused")
			String _tmp = ch.getPage();
		} catch (IOException e1) {
			logger.error("IOException",e1);
		}

		// 60 secondi per consentire al log4j di fare il suo lavoro
		try {
			Thread.sleep(60000);
		} catch (InterruptedException e1) {
			logger.error("InterruptedException",e1);
		}

		Vector a_files = Files.getFilesInFolder(path, logFileBaseName + ".*");

		// *** Caricamento dei file ***
		for (int i = 0; i < a_files.size(); i++) {
			String fileText = path + a_files.get(i);
			if (logger.isDebugEnabled())
				logger.debug("filetext:" + fileText);
			if (!"".equals(fileText)) {
				FileReader fr = new FileReader(fileText);
				BufferedReader br = new BufferedReader(new FileReader(fileText));
				String nextLine = "";

				Dati dati = new Dati();

				while ((nextLine = br.readLine()) != null) {
					String[] columns = null;
					if (nextLine.indexOf("") != -1) {
						columns = nextLine.split("\\");
						dati.setSessionId(columns[0].trim());
						dati.setData(columns[1].trim());
						dati.setIp(columns[2].trim());
						dati.setUser_agent(columns[3].trim());
						dati.setReferer(columns[4].trim());
						dati.setUsername(columns[5].trim());
						dati.setProfilo(columns[6].trim());
						dati.setServlet_name(columns[7].trim());
						dati.setServlet_code(columns[8].trim());
						try {
							dati.setRequest_params(columns[9].trim());
						} catch (Exception e) {
						}
						try {
							dati.insert(DatabaseManager.getInstance().getCMSConnectionManager());
						} catch (Exception e) {
							// nel caso in cui il file di tale giorno sia stato gi inserito
							logger.warn(e.toString(), e);
						}
					}
				}
				fr.close();
				br.close();
				fr = null;
				br = null;

				String fileDest = path + File.separator + "old" + File.separator + a_files.get(i);
				if (logger.isDebugEnabled())
					logger.debug("file dest: " + fileDest);
				FileCopy.copy(fileText, fileDest);

				File file = new File(fileText);
				boolean success = file.delete();
				if (logger.isDebugEnabled())
					logger.debug(success);
				if (!success) {
					logger.warn("Il file " + a_files.get(i) + " non  stato cancellato");
				}
			}
		}
	}

}
