package it.softecspa.analyzer;
import java.io.IOException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;

public class LogClientHTTP {

	  	private String _url;
		private int _statusCode = -1;
		private boolean _followRedirects = true;
		private int _timeout = 5*1000;
		private byte[] responseBody;

		public LogClientHTTP(String url) {
			_url = url;
		}
		
	/**
	 * @return Returns the _statusCode.
	 */
		public int getStatusCode() {
			return _statusCode;
		}
		
	/**
	 * @return Returns the responseBody.
	 */
		public byte[] getResponseBody() {
			return responseBody;
		}
		
	/**
	 * @param redirects The _followRedirects to set.
	 */
		public void setFollowRedirects(boolean redirects) {
			_followRedirects = redirects;
		}
		
	/**
	 * @param _timeout The _timeout to set.
	 */
		public void setTimeout(int timeout) {
			_timeout = timeout;
		}
		

		public String getPage() throws IOException {
//	 Create an instance of HttpClient.
			HttpClient client = new HttpClient();
//	 establish a connection within _timeout seconds    	
			client.getHttpConnectionManager().getParams().setConnectionTimeout(_timeout);
//	 Create a method instance.
			GetMethod get = new GetMethod(_url);
			get.setFollowRedirects(_followRedirects);

			try {
				_statusCode = client.executeMethod(get);

				if (_statusCode != HttpStatus.SC_OK)
					throw new IOException("Method failed: " + get.getStatusLine());
//	 Read the response body.
				responseBody = get.getResponseBody();

			} catch (IOException e) {
				throw new IOException("Unable retrive page " + _url + "cause " + e);
			} finally {
//	 Release the connection.
				get.releaseConnection();
			}
			return new String(responseBody);
		}	
		
	}