/*
 * Created on 21-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.analyzer.inputValidator;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

/**
 * 
 */
public class ReportAnalyzerIV extends InputValidator {

	public void doValidate(HttpServletRequest request, Session session, Hashtable<String, Object> fod) throws InputValidatorException {
		try {
			Utente utente = (Utente) session.getUser();
			Locale currentLocale = null;
			ResourceBundle bundle = null;
			if (utente.getLanguage() != null) {
				currentLocale = new Locale(utente.getLanguage(), utente.getLanguage().toUpperCase());
				bundle = ResourceBundle.getBundle("jwebber_dictionary", currentLocale, Thread.currentThread().getContextClassLoader());
			}
			if (utente != null && (utente.hasPolicy(CMSConstants.POLICY_ADMIN_AREA_ACCESS) || utente.hasPolicy(CMSConstants.POLICY_ADMIN_SITE_STATISTICS))) {
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ok");
			} else {
				fod.put(CMSConstants.USER_CAN_PROCEDE, "ko");
				fod.put(CMSConstants.WARNING_MESSAGE, bundle.getString("msgAuthorizationErrorOperation"));
				return;
			}

			// Indica il tipo di azione che si sta compiendo
			String action = (String)fod.get("action");
			if (action == null)
				action = "";
			fod.put("action", action);

			String strWarning = "";

			// Controllo se ho a che fare con un postback
			boolean postBack = ("1".equals((String) fod.get("postBack"))) ? true : false;

			if (postBack) {
				if ("print".equals(action)) {
					String rd = (String) fod.get("group1");
					String dataStart = (String) fod.get("dataStart");
					String dataEnd = (String) fod.get("dataEnd");
					String data = (String) fod.get("data");

					if ("periodo".equals(rd) && ("".equals(dataStart) || "".equals(dataEnd))) {
						strWarning += "Hai selezionato Periodo, quindi i campi Data inizio e Data fine non possono essere vuoti \\n";
					} else {
						if ("periodo".equals(rd) && (!"".equals(dataStart) || !"".equals(dataEnd))) {
							Date dtStart = new SimpleDateFormat("dd/MM/yyyy").parse(dataStart);
							Date dtEnd = new SimpleDateFormat("dd/MM/yyyy").parse(dataEnd);

							if (!dtStart.before(dtEnd))
								strWarning += "Data inizio deve essere minore di Data fine \\n";
						}
					}

					if ("giorno".equals(rd) && "".equals(data))
						strWarning += "Hai selezionato Giorno, quindi il campo Data non pu essere vuoto \\n";
				}
			} else {
				Date now = new Date();
				String strNow = new SimpleDateFormat("dd/MM/yyyy").format(now);
				;
				String dataStart = "01" + strNow.substring(2);

				fod.put("dataStart", dataStart);
				fod.put("dataEnd", strNow);
				fod.put("data", strNow);
			}
			fod.put(CMSConstants.WARNING_MESSAGE, strWarning);
		} catch (Exception e) {
			throw new InputValidatorException("", e);
		}
	}
}
