package it.softecspa.indexer;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.portal.Parameters;
import it.softecspa.task.WebTimerTask;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

import javax.servlet.ServletConfig;

import net.nutch.tools.CrawlTool;
import net.nutch.util.NutchConf;

import org.apache.log4j.Logger;

public class IndexerTask extends WebTimerTask {
	
	private static Logger logger = Logger.getLogger(IndexerTask.class);	
	private String startUrl = "";
	private String profile  = "";
	
	public IndexerTask() {		
	}	
	
	/*protected void setConfig(ServletConfig config) {
		try {
			this.config = config;
		} catch(Exception e) {	
			logger.error("Errore nell'inizializzazione della Classe.", e);
		}
	}*/
	
	protected void setParams(){		
		Parameters parameters = Parameters.getInstance();
		
		this.startUrl = params.get("startUrl")!=null?(String)params.get("startUrl"):parameters.get("base.url");
		this.profile = params.get("profile")!=null?(String)params.get("profile"):CMSConstants.PROFILO_ANONIMO.toLowerCase();
	}
	
	protected void setConfig(ServletConfig config) {
		this.config = config;
	}
	
	protected void doRun() {
		try{
			doIndex();
		} catch (Exception e) {
			logger.error("Unhandled exception", e);
		}
	}
	
	private boolean deleteDirectory(File path) {
		if( path.exists() ) {
			File[] files = path.listFiles();
			for(int i=0; i<files.length; i++) {
				if(files[i].isDirectory()) {
					deleteDirectory(files[i]);
				}
				else {
					files[i].delete();
				}
			}
		}
		return( path.delete() );
	}
	
	private boolean createDirectory(File path) {
		if( ! path.exists() ) {
			return path.mkdirs();
		} else {
			return true;
		}
	}
	
	@SuppressWarnings("unused")
	private void doIndex() {
		try {
			// Creo il file con la url iniziale
			String searcherDir = NutchConf.get("searcher.dir"); // nel file nutch-default.xml
			if (!searcherDir.endsWith("/")) {
				searcherDir += "/";
			}
			String searcherDirProfile = searcherDir + profile + "/";
	
			File path = new File(searcherDirProfile);
			// se non esiste crea la cartella searcherDir
			boolean dummy = createDirectory(path);

			// cancella ricorsivamente le sottocartelle della cartella searcherDir prima di far partire CrawlTool
			dummy = deleteDirectory(path);
			
			// creo al volo il file con la URL iniziale
			String startUrlFileName = searcherDir + profile +  "_url.txt"; 
			BufferedWriter bw = new BufferedWriter(new FileWriter(startUrlFileName));
			bw.write(startUrl);
			bw.close();
			
			// Preparo i parametri per la chiamata all'indicizzatore
			String params[] = new String[5];
			// File con la Url iniziale
			params[0] = startUrlFileName;
			// Parametro -dir
			params[1] = "-dir"; 
			// Directory dove creare il file indice
			params[2] = searcherDirProfile; 
			// Parametro -depth
			params[3] = "-depth";
			// Livello di profondit del crawling
			params[4] = "5";
			
			CrawlTool.main(params);
			
			} catch (Exception e) {
				logger.error("Unhandled exception", e);
			}
	}
}
