package it.softecspa.indexer.inputValidator;

import it.softecspa.mvc.businesslogic.InputValidator;
import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.mvc.session.Session;
import it.softecspa.portal.Parameters;

import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;

public class TextSearchIV extends InputValidator {

	public void doValidate(HttpServletRequest request, Session session, Hashtable<String,Object> fod) throws InputValidatorException {
		
		// FIXME legge il default hits per page dal portal_settings.properties
		Parameters parameters = Parameters.getInstance();
		String default_hitsPerPage = parameters.get("HITS_PER_PAGE");

		String query = null;
		if (fod.get("query") != null) {
			query = ((String) fod.get("query")).trim();
		} 
		
		if (query == null || "".equals(query)) {
			fod.put("TEXT_SEARCH_ERROR","Specify a text");
		}
		
		if(fod.get("start") == null)
       		fod.put("start","0");
		if(fod.get("curPage") == null)
       		fod.put("curPage","1");
		if(fod.get("hitsPerPage") == null)
			fod.put("hitsPerPage",default_hitsPerPage);
		if(fod.get("hitsPerSite") == null)
       		fod.put("hitsPerSite","0");
		if(fod.get("clustering") == null)
       		fod.put("clustering","");
		
		fod.put("application", request.getSession().getServletContext());
	}

}