package it.softecspa.indexer.processRequest;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.mvc.businesslogic.ProcessRequest;
import it.softecspa.mvc.businessobject.User;
import it.softecspa.mvc.exceptions.ProcessingException;

import java.io.IOException;
import java.util.Hashtable;

import javax.servlet.ServletContext;

import net.nutch.clustering.OnlineClusterer;
import net.nutch.clustering.OnlineClustererFactory;
import net.nutch.plugin.PluginRuntimeException;
import net.nutch.searcher.Hit;
import net.nutch.searcher.HitDetails;
import net.nutch.searcher.Hits;
import net.nutch.searcher.NutchBean;
import net.nutch.searcher.Query;
import net.nutch.util.NutchConf;

public class TextSearchPR extends ProcessRequest {


	@SuppressWarnings("unused")
	public void doProcess(Hashtable<String,Object> fod) throws ProcessingException {
		if (fod.get("TEXT_SEARCH_ERROR") == null) {

			// TODO ricavare la root ROOT_OF_FILE_INDEX dei file di indice
			// dall'indexer.properties
			User utente = (User) session.getUser();

			String profilo = CMSConstants.PROFILO_ANONIMO.toLowerCase();
			// Commentando la riga sottostante si forza tutti gli utenti ad
			// usare il profilo anonimo
			// if (utente != null) profilo =
			// utente.getIdProfilo().toLowerCase();

			String queryString = (String) fod.get("query");
			String curPage = (String) fod.get("curPage");

			// Adesso faccio quello che faceva la jsp remota

			NutchBean bean;
			try {
				bean = NutchBean.get((ServletContext) fod.get("application"), "", profilo);

				// a flag to make the code cleaner a bit.
				boolean clusteringAvailable = (clusterer != null);

				String clustering = "";
				if (clusteringAvailable && "yes".equals((String) fod.get("clustering"))) {
					clustering = "yes";
				}

				int start = 0; // first hit to display
				String startString = (String) fod.get("start");
				if (startString != null)
					start = Integer.parseInt(startString);

				int hitsPerPage = 10; // number of hits to display
				String hitsString = (String) fod.get("hitsPerPage");
				if (hitsString != null)
					hitsPerPage = Integer.parseInt(hitsString);

				int hitsPerSite = 2; // max hits per site
				String hitsPerSiteString = (String) fod.get("hitsPerSite");
				if (hitsPerSiteString != null)
					hitsPerSite = Integer.parseInt(hitsPerSiteString);

				int hitsToCluster = HITS_TO_CLUSTER; // number of hits to
														// cluster

				Query query = Query.parse(queryString);

				// ZZ String requestURI =
				// HttpUtils.getRequestURL(request).toString();
				// ZZ String base = requestURI.substring(0,
				// requestURI.lastIndexOf('/'));

				// how many hits to retrieve? if clustering is on and available,
				// take "hitsToCluster", otherwise just get hitsPerPage
				int hitsToRetrieve = (clusteringAvailable && clustering.equals("yes") ? hitsToCluster : hitsPerPage);

				// perform query
				Hits hits = bean.search(query, start + hitsToRetrieve, hitsPerSite);
				int end = (int) Math.min(hits.getLength(), start + hitsPerPage);
				int length = end - start;
				int realEnd = (int) Math.min(hits.getLength(), start + hitsToRetrieve);
				fod.put("totHits", "" + hits.getTotal());

				Hit[] show = hits.getHits(start, realEnd - start);
				HitDetails[] details = bean.getDetails(show);
				String[] summaries = bean.getSummary(details, query);

				// preparo i risultati
				fod.put("show", show);
				fod.put("details", details);
				fod.put("summaries", summaries);

			} catch (IOException e) {
				logger.error("IOException",e);
			}
		}
	}

	/**
	 * Number of hits to retrieve and cluster if clustering extension is
	 * available and clustering is on. By default, 100. Configurable via
	 * nutch-conf.xml.
	 */
	private final static int HITS_TO_CLUSTER = NutchConf.getInt("extension.clustering.hits-to-cluster", 100);

	/**
	 * An instance of the clustering extension, if available.
	 */
	private static OnlineClusterer clusterer;

	static {
		try {
			clusterer = OnlineClustererFactory.getOnlineClusterer();
		} catch (PluginRuntimeException e) {
			// NOTE: Dawid Weiss
			// should we ignore plugin exceptions, or rethrow it? Rethrowing
			// it effectively prevents the servlet class from being loaded into
			// the JVM
		}
	}

}
