/*
 * Created on 16-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber;

import it.softecspa.portal.Parameters;

import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * @author d.cristofani
 * 
 *         TODO To change the template for this generated type comment go to
 *         Window - Preferences - Java - Code Style - Code Templates
 */
public class CMSUtilities {
	/**
	 * Converte una stringa in un Integer.
	 * 
	 * @param value
	 *            La stringa da convertire.
	 * 
	 * @return Il valore Integer della stringa o null se la stringa non
	 *         rappresenta un intero
	 */
	static public Integer getInteger(String value) {
		Integer ret = null;

		try {
			ret = Integer.decode(value);
		} catch (Exception e) {
			ret = null;
		}

		return ret;
	}

	/**
	 * Controlla se una stringa rappresenta un valore intero.
	 * 
	 * @param value
	 *            La stringa da controllare.
	 * 
	 * @return True se la stringa  un intero, False altrimenti.
	 */
	static public boolean isIntValue(String value) {
		boolean ret = true;

		try {
			Integer.parseInt(value);
		} catch (Exception e) {
			ret = false;
		}

		return ret;
	}

	/**
	 * @deprecated da m.veroni
	 * Converte una stringa in formato SQL.
	 * 
	 * @param str
	 *            Stringa da convertire.
	 * 
	 * @return La stringa nel nuovo formato.
	 * 
	 */
	public static String fn_StringToSQLString(String str) {
		if (str == null)
			return "";

		String retStr = str;

		for (int ic = retStr.length() - 1; ic >= 0; ic--) {
			char ch = retStr.charAt(ic);
			switch (ch) {
			case '\'':
				retStr = retStr.substring(0, ic) + "'" + retStr.substring(ic);
				break;
			}
		}

		return retStr;
	}

	/**
	 * Converte una stringa in formato JavaScript.
	 * 
	 * @param str
	 *            : Stringa da trasformare.
	 * 
	 * @return Una stringa contenente la stringa convertita.
	 */
	static public String fn_StringToJSString(String str) {
		String retString = str;

		if (str != null && !"".equals(str)) {
			for (int ic = str.length() - 1; ic >= 0; ic--) {
				char ch = retString.charAt(ic);
				switch (ch) {
				case '\'':
					retString = retString.substring(0, ic) + "\\\'" + retString.substring(ic + 1);
					break;
				case '"':
					retString = retString.substring(0, ic) + "\\\"" + retString.substring(ic + 1);
					break;
				case '\\':
					retString = retString.substring(0, ic) + "\\\\" + retString.substring(ic + 1);
					break;
				}
			}
		}

		return retString;
	}

	/**
	 * 
	 * Converte una stringa escapando l'HTML che contiene.
	 * Modificata per gestire vari tipi di oggetti
	 * @author m.veroni
	 * 
	 * @param str
	 *            : Stringa da trasformare.
	 * 
	 * @return Una stringa contenente la stringa convertita.
	 */
	static public String fn_StringToHTMLString(Object value) {
		return fn_StringToHTMLString(value, null);
	}

	static public String fn_StringToHTMLString(Object value, String formato) {
		if (value == null)
			return "";

		if (value instanceof String) {
			String str = (String) value;
			String retString = str;

			if (str.indexOf('"') >= 0) {
				for (int ic = str.length() - 1; ic >= 0; ic--) {
					char ch = retString.charAt(ic);
					switch (ch) {
					case '"':
						retString = retString.substring(0, ic) + "&quot;" + retString.substring(ic + 1);
						break;
					}
				}
				return retString;
			}

		} else if (value instanceof Calendar) {
			Calendar dtm = (Calendar) value;
			if (formato == null) {
				formato = Parameters.getInstance().get(Parameters.DATETIME_FORMAT,"yyyy-MM-dd HH.mm.ss");
			}
			SimpleDateFormat dateFormat = new SimpleDateFormat(formato);
			return dateFormat.format(dtm.getTime());
		}

		return value.toString();
	}

	static public String fn_StringFormatter(String str, String param) {
		str = str.replaceFirst("%s", param);

		return str;
	}

	static public String fn_StringFormatter(String str, String param1, String param2) {
		str = str.replaceFirst("%s", param1);
		str = str.replaceFirst("%s", param2);

		return str;
	}
}
