/*
 * Created on 14-mar-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.bo;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.frameworkImpl.AppCostanti;
import it.softecspa.jwebber.frameworkImpl.bo.Profilo;
import it.softecspa.jwebber.frameworkImpl.security.CMSAdminImplSecurityManager;
import it.softecspa.jwebber.frameworkImpl.security.CMSImplPolicyManager;
import it.softecspa.kahuna.sql.QueryFormatter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;
import it.softecspa.mvc.businesslogic.Paginatore;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.businessobject.DbGeneric;
import it.softecspa.mvc.businessobject.User;
import it.softecspa.mvc.exceptions.AuthenticationException;
import it.softecspa.mvc.utils.SecurityUtils;
import it.softecspa.portal.Bundle;
import it.softecspa.portal.Parameters;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;

/**
 * Utente
 */
@SuppressWarnings("serial")
public class Utente extends User implements DbGeneric, Serializable {

	/**
	 * Definisce lo stato di cancellazione logica
	 */
	public static final String STATO_DELETED = AppCostanti.STATO_DELETED;

	/**
	 * Definisce lo stato di utente che ha una password provvisoria
	 */
	public static final String STATO_CHANGE_PASSWORD = "CP";

	/**
	 * Definisce lo stato di un utente Attivo
	 */
	public static final String STATO_ATTIVO = "A";

	/**
	 * Definisce la categoria per l'internazionalizzazione
	 */
	public static final String I18N_DISCRIMINATOR = "999";

	/**
	 * Contiene gli alias di tutti i campi del db. Utile nelle query impedisce
	 * che nelle select in join con altre tabelle ci siano campi con lo stesso
	 * nome
	 */
	public static final String SQL_STAR = "cms_33_utente.userid as UTENTE_0000, cms_33_utente.username as UTENTE_0001, cms_33_utente.password as UTENTE_0002, cms_33_utente.id_profilo as UTENTE_0003, cms_33_utente.nome as UTENTE_0004, cms_33_utente.cognome as UTENTE_0005, cms_33_utente.stato as UTENTE_0013, cms_33_utente.can_see_preview ";

	
	private String nome;
	private String cognome;
	private Profilo profilo;
	
	
	private boolean canSeePreview;

	private boolean anonimo;

	/**
	 * Definisce il livello di ricorsione di alcune query in join La sua
	 * impostazione  prerogativa esclusiva dei metodi che eseguono le query
	 */
	private int livelloRicorsione = 0;

	private Logger logSQL = DatabaseStatement.getLoggerSQL();
	
	
	public Utente() {	
		super();
	}

	

	public Utente(int livelloRicorsione) {
		this.livelloRicorsione = livelloRicorsione;
	}

	
	
	public boolean isCanSeePreview() {
		return canSeePreview;
	}

	public void setCanSeePreview(boolean canSeePreview) {
		this.canSeePreview = canSeePreview;
	}
	
	
	
	

	/**
	 * Imposta il valore di password. Nell'impostazione la password viene
	 * criptata per motivi di sicurezza. Ogni volta che si vorr utilizzare
	 * questo campo per fare confronti con una password in chiaro, bisogner
	 * chiamare il metodo verificaPassword La password in chiaro deve essere di
	 * almeno 8 caratteri
	 */
	public void setPassword(String value) throws Exception {
		// imposto la password registrandola in maniera criptata
		password = CMSAdminImplSecurityManager.criptaPassword(value);
	}

	public void setUncryptedPassword(String cryptedvalue) {
		// imposto la password registrandola in maniera non criptata
		password = cryptedvalue;
	}

	

	/**
	 * Imposta il valore di profilo
	 */
	public void setProfilo(Profilo profilo) {
		this.profilo = profilo;
		if (idProfilo==null && profilo!=null) this.idProfilo = profilo.getIdProfilo();
	}

	/**
	 * Restituisce il valore di profilo
	 */
	public Profilo getProfilo() {
		return profilo;
	}
	
	/**
	 * Restituisce il valore di profilo prelevandolo dal db se lo si desidera
	 * 
	 * @param retrieveIfNull
	 *            Un flag che indica se l'oggetto deve essere prelevato dal db
	 *            nel caso in cui fosse nullo
	 */
	public Profilo getProfilo(boolean retrieveIfNull) throws Exception {
		if (this.profilo == null && retrieveIfNull) {
			Connection conn = null;
			try {
				conn = DatabaseManager.getInstance().getConnection();
				this.profilo = new Profilo();
				this.profilo.setIdProfilo(this.idProfilo);
				this.profilo.retrieveByKey(conn);
			} catch (Exception e) {
				throw e;
			} finally {
				DatabaseManager.closeConnection(conn);
			}
		}
		return profilo;
	}

	
	/**
	 * Imposta il valore di nome
	 */
	public void setNome(String nome) {
		this.nome = nome;
	}

	/**
	 * Restituisce il valore di nome
	 */
	public String getNome() {
		return nome;
	}

	
	/**
	 * Imposta il valore di cognome
	 */
	public void setCognome(String cognome) {
		this.cognome = cognome;
	}

	/**
	 * Restituisce il valore di cognome
	 */
	public String getCognome() {
		return cognome;
	}

	
	/**
	 * Imposta il valore di stato
	 */
	public void setStato(String stato) {
		this.stato = stato;
	}

	

	/**
	 * Aggiorna l'oggetto con il contenuto del ResultSet.
	 * 
	 * @param r
	 *            Il risultato della query su db
	 */
	public void getFromResultSet(ResultSet r) throws SQLException {
		idUtente = r.getInt("UTENTE_0000");
		username = r.getString("UTENTE_0001");
		password = r.getString("UTENTE_0002");
		idProfilo = r.getString("UTENTE_0003");
		nome = r.getString("UTENTE_0004");
		cognome = r.getString("UTENTE_0005");
		stato = r.getString("UTENTE_0013");
		canSeePreview = r.getInt("CAN_SEE_PREVIEW") == 1;
		if (this.livelloRicorsione > 0) {
			this.profilo = new Profilo();
			this.profilo.getFromResultSet(r, (this.livelloRicorsione - 1));
		}
	}

	
	/**
	 * Aggiorna l'oggetto con il contenuto del ResultSet. Dal momento che questa
	 * classe potrebbe contenere oggetti complessi che potrei non aver voluto
	 * tirare fuori da una query, un indicatore di livello mi dice il punto in
	 * cui fermarmi.
	 * 
	 * @param r
	 *            Il risultato della query su db
	 * @param livello
	 *            il livello a cui fermarsi. Il livello inizia con 0 ed indica i
	 *            campi di questa classe
	 */
	public void getFromResultSet(ResultSet r, int livello) throws SQLException {
		this.livelloRicorsione = livello;
		this.getFromResultSet(r);
	}

	/**
	 * Recupera i dati dal db
	 * 
	 * @param conn
	 *            La connessione al database
	 * @param USERID
	 * @return L'esito della ricerca
	 */
	public boolean retrieveByKey(Connection conn) throws SQLException {
		boolean TGstatus = false;
		this.livelloRicorsione = 99;
		String query = "select " + getSqlStarForJoin(this.livelloRicorsione) + 
					  " from " + getTableNameForJoin(this.livelloRicorsione) + 
					  " WHERE userid=? " + getClausolaForJoin(this.livelloRicorsione, "AND");
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		ResultSet r = null;
		try {
			pstm = conn.prepareStatement(query);
			pstm.setInt(1, this.idUtente);
			r = pstm.executeQuery();
			if (r.next()) {
				getFromResultSet(r);
				TGstatus = true;
			}
		} finally {
			DatabaseManager.closeResultSet(r);
			DatabaseManager.closeStatement(pstm);
		}
		return TGstatus;
	}

	/**
	 * Aggiorna l'oggetto sul database.
	 * 
	 * @param conn
	 *            La connessione al DB
	 * @return Il numero di record modificati
	 */
	public int updateByKey(Connection conn) throws SQLException {
		String query = "update cms_33_utente set userid=?, username=?,id_profilo=?,nome=?,cognome=?,stato=?,can_see_preview=? where userid=?";
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		try {
			pstm = conn.prepareStatement(query);
			pstm.setInt(1, this.idUtente);
			pstm.setString(2, this.username);
			pstm.setString(3, this.profilo.getIdProfilo());
			pstm.setString(4, this.nome);
			pstm.setString(5, this.cognome);
			pstm.setString(6, this.stato);
			pstm.setInt(7, this.idUtente);
			pstm.setInt(8, this.canSeePreview ? 1 : 0);

			int updated = pstm.executeUpdate();
			return updated;
		} finally {
			DatabaseManager.closeStatement(pstm);
		}

	}

	/**
	 * Cancella dalla tabella "UTENTE"
	 * 
	 * @param conn
	 *            La connessione al database
	 */
	public int deleteByKey(Connection conn) throws SQLException {
		String query = "delete cms_33_utente" + " where userid=?";
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		try {
			pstm = conn.prepareStatement(query);
			pstm.setInt(1, this.idUtente);
			int deleted = pstm.executeUpdate();
			return deleted;
		} finally {
			DatabaseManager.closeStatement(pstm);
		}
	}

	/**
	 * Cancella l'oggetto logicamente sul database. La cancellazione consiste
	 * nell'apposizione di un flag che rende il record invisibile a tutte le
	 * ricerche tranne quelle per chiave.
	 * 
	 * @param conn
	 *            La connessione al DB
	 * @return Il numero di record modificati
	 */
	public int deleteSoft(Connection conn) throws SQLException {
		String query = "update cms_33_utente set stato = '" + STATO_DELETED + "'" + " where userid=?";
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		try {
			pstm = conn.prepareStatement(query);
			pstm.setInt(1, this.idUtente);
			int updated = pstm.executeUpdate();
			return updated;
		} finally {
			DatabaseManager.closeStatement(pstm);
		}
	}

	/**
	 * Restituisce tutti i nomi delle tabelle incluse in una select di join. Il
	 * metodo chiama anche un metodo chiamato come questo negli oggetti
	 * relazionati, cos che la cosa possa essere ricorsiva Es: Cliente contiene
	 * l'oggetto Indirizzo che a sua volta contiene l'oggetto Provincia
	 * Chiamando il metodo writeGetTableNameForJoin() di Indirizzo che a sua
	 * volta chiama il metodo writeGetTableNameForJoin() di Provincia, i nomi
	 * delle tabelle dei campi relazionati verranno inseriti e si potr fare una
	 * join fra tutti gli oggetti in gioco I livelli iniziano da 0 (che il
	 * livello dell'oggetto corrente)
	 * 
	 * @param livello
	 *            Il livello di profondit che voglio raggiungere della query
	 */
	public static String getTableNameForJoin(int livello) {
		String tableNames = "cms_33_utente";
		if (livello > 0) {
			livello--;
			tableNames += "," + Profilo.getTableNameForJoin(livello);
		}
		return tableNames;
	}

	/**
	 * Restituisce tutti i campi della tabella pi i campi delle tabelle ad essa
	 * relazionate. Il metodo chiama anche un metodo chiamato come questo negli
	 * oggetti relazionati, cos che la cosa possa essere ricorsiva Es: Cliente
	 * contiene l'oggetto Indirizzo che a sua volta contiene l'oggetto Provincia
	 * Chiamando il metodo getSql_starForJoin() di Indirizzo che a sua volta
	 * chiama il metodo getSql_starForJoin() di Provincia, i campi verranno
	 * inserite tutti e si potr fare una join fra tutti gli oggetti in gioco I
	 * livelli iniziano da 0 (che il livello dell'oggetto corrente)
	 * 
	 * @param livello
	 *            Il livello di profondit che voglio raggiungere della query
	 */
	public static String getSqlStarForJoin(int livello) {
		String sqlStar = SQL_STAR;
		if (livello > 0) {
			livello--;
			sqlStar += "," + Profilo.getSql_starForJoin(livello);
		}
		return sqlStar;
	}

	/**
	 * Restituisce le eguaglianze di relazione della tabella in questione. Dal
	 * momento che alcuni oggetti inclusi in questo sono semplicemente id legati
	 * ad altre tabelle questo metodo genera una clausola SQL che permette di
	 * legare tutte le tabelle legate alla tabella che rappresenta l'oggetto. Il
	 * metodo chiama anche un metodo chiamato come questo negli oggetti
	 * relazionati, cos che la cosa possa essere ricorsiva Es: Cliente contiene
	 * l'oggetto Indirizzo che a sua volta contiene l'oggetto Provincia
	 * Chiamando il metodo getClausolaForJoin() di Indirizzo che a sua volta
	 * chiama il metodo getClausolaForJoin() di Provincia, le clausole verranno
	 * inserite tutte e si potr fare una join fra tutti gli oggetti in gioco I
	 * livelli iniziano da 0 (che il livello dell'oggetto corrente)
	 * 
	 * @param livello
	 *            Il livello di profondit che voglio raggiungere della query
	 */
	public static String getClausolaForJoin(int livello, String clausolaAnd) {
		String joinClausole = "";
		if (livello > 0) {
			livello--;
			joinClausole += clausolaAnd;
			joinClausole += " cms_33_utente.id_profilo=cms_30_profilo.id_profilo";
		}
		return joinClausole;
	}

	/**
	 * Recupera tutti i dati dal database
	 * 
	 * @param conn
	 *            La connessione al database
	 * @param orderBy
	 *            L'elenco dei campi di cui chiedere l'ordinamento. Tali campi
	 *            sono quelli della tabella e sono separati dal carattere ",".
	 * @param numPagina
	 *            il numero della pagina che si desidera estrarre (serve per non
	 *            estrarre tutti i record della select). Il La prima pagina  la
	 *            pagina 0. Se la pagina  -1 vengono prelevati tutti i record
	 * @return L'elenco degli oggetti reperiti dal db
	 */
	@SuppressWarnings("rawtypes")
	public ArrayList retrieveAll(Connection conn, String orderBy, Paginatore paginatore, String iso639) throws Exception {
		this.livelloRicorsione = 1;
		String query = "select " + getSqlStarForJoin(this.livelloRicorsione) + " from " + getTableNameForJoin(this.livelloRicorsione) + getClausolaForJoin(this.livelloRicorsione, " where ");
		// gli utenti cancellati non li carico
		query = query + " AND cms_33_utente.stato != ?";

		if (orderBy != null) {
			query += " order by " + orderBy;
		}
		PreparedStatement pstm = conn.prepareStatement(query);
		pstm.setString(1, Utente.STATO_DELETED);
		ResultSet r = pstm.executeQuery();
		paginatore.getFromQuery(r, this);
		return paginatore.getVBusinessObj();
	}

	/**
	 * Inserisce l'oggetto nel database database.
	 * 
	 * @param conn
	 *            La connessione al DB
	 * @return Il numero di record inseriti
	 */
	public int insert(Connection conn) throws SQLException {
		String query = "insert into cms_33_utente ( userid,username,password,id_profilo,nome,cognome,stato,can_see_preview) values (?,?,?,?,?,?,?,?)";
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		try {
			pstm = conn.prepareStatement(query);
			pstm.setInt(1, this.idUtente);
			pstm.setString(2, this.username);
			pstm.setString(3, this.password);
			pstm.setString(4, this.profilo.getIdProfilo());
			pstm.setString(5, this.nome);
			pstm.setString(6, this.cognome);
			pstm.setString(7, this.stato);
			pstm.setInt(8, this.canSeePreview ? 1 : 0);

			int inseriti = pstm.executeUpdate();
			return inseriti;
		} finally {
			DatabaseManager.closeStatement(pstm);
		}
	}

	/**
	 * Restituisce la chiave primaria dell'oggetto in formato Stringa
	 */
	public String getPrimaryKey() throws Exception {
		return String.valueOf(this.idUtente);
	}

	/**
	 * Restituisce la chiave primaria dell'oggetto in formato Stringa
	 */
	public void setPrimaryKey(String pk) throws Exception {
		StringTokenizer st = new StringTokenizer(pk, AppCostanti.PK_DB_GEN_SEPARATOR);
		this.setIdUtente(st.nextToken());
	}

	/**
	 * Stampa tutti i campi dell'oggetto
	 * 
	 * @return L'oggetto in formato Stringa
	 */
	public String toString() {
		String out = "";
		out += ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
		out += "Oggetto: " + this.getClass() + " - " + super.toString() + "\n";
		out += "IdUtente: <" + this.idUtente + ">\n";
		out += "Password: <" + this.password + ">\n";
		out += "Profilo: <" + this.profilo + ">\n";
		out += "Nome: <" + this.nome + ">\n";
		out += "Cognome: <" + this.cognome + ">\n";
		out += "Stato: <" + this.stato + ">\n";
		out += "CanSeePreview: <" + this.canSeePreview + ">\n";
		out += ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
		return out;
	}



	/**
	 * Crea un'istanza della classe e la restituisce
	 * 
	 * @return l'istanza della classe
	 */
	public DbGeneric getIstance() {
		return new Utente(this.livelloRicorsione);
	}

	

	/**
	 * Restituisce la denominazione dell'utente. La denominazione  formata da:
	 * "nome cognome"
	 */
	public String getDenominazione() {
		return this.nome + " " + this.cognome;
	}

	/**
	 * Esegue la loghin nel modo standard, effettuando la verifica della password
	 * @param conn
	 * @return
	 * @throws SQLException
	 * @throws AuthenticationException
	 */
	public boolean login(Connection conn) throws SQLException, AuthenticationException {
		return login(conn, true);
	}
	
	public boolean loginWithoutPassword(Connection conn) throws SQLException, AuthenticationException {
		return login(conn, false);
	}
	/**
	 * Effettua il login dell'utente
	 * Il parametro indca o meno la verifica della password
	 * @param conn
	 * @param use_password
	 * @return
	 * @throws SQLException
	 * @throws AuthenticationException
	 */
	private boolean login(Connection conn, boolean use_password) throws SQLException, AuthenticationException {
		anonimo = false;

		boolean bStatus = false;
		String query = "select " + getSqlStarForJoin(2) + 
		              " from " + getTableNameForJoin(2) + 
		              " WHERE username = '"+this.username + "'" +
				      (use_password?" AND password = ?":"") +
				        getClausolaForJoin(2, " AND ");
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		ResultSet r = null;
		try {
			pstm = conn.prepareStatement(query);
			if (use_password) pstm.setString(1, this.password);
			r = pstm.executeQuery();
			if (r.next()) {
				getFromResultSet(r, 2);
				bStatus = true;
			} else {
				if (use_password) {
					String messaggio = Bundle.getInstance().getBundle().getString("msgUserNotExist");
					throw new AuthenticationException(messaggio, true);
				} else {
					String messaggio = Bundle.getInstance().getBundle().getString("msgUserNotExistSSO");
					throw new AuthenticationException(messaggio, true);
				}
			}
		} finally {
			DatabaseManager.closeResultSet(r);
			DatabaseManager.closeStatement(pstm);
		}
		
		if (bStatus) {
			if (Utente.STATO_ATTIVO.equalsIgnoreCase(stato)) return true;
			if (Utente.STATO_CHANGE_PASSWORD.equalsIgnoreCase(stato)) return true;
			return false;
		}
		return bStatus;
	}
	
	
	
	public boolean loginWithToken(Connection conn, String token) throws SQLException, AuthenticationException {
		anonimo = false;    	
    	
		boolean bStatus = false;
        String query = "select " + getSqlStarForJoin(2) + 
        			  " from " + getTableNameForJoin(2) 
        			+ " WHERE ( cms_33_utente.stato = '" + Utente.STATO_ATTIVO + "'  OR "
        			+ " cms_33_utente.stato = '" + Utente.STATO_CHANGE_PASSWORD + "' ) "
        			+ " AND (username is not null AND username <> \"\" AND md5(concat(username,?))=?)"
        			+ getClausolaForJoin(2, " AND ");        
        
        /* Query di esempio per estrazione token
         select userid, username, md5(concat(username,'.desktopmate.',date_format(NOW(),'%Y%m%d'))) as "token", concat(username,'.desktopmate.',date_format(NOW(),'%Y%m%d'))
		 from cms_33_utente 
		 WHERE (username is not null AND username <> "")
         */
        String aggiunta = ".desktopmate."+EnterpriseCalendar.now().format("yyyyMMdd");
    	        
        PreparedStatement pstm = null;
		ResultSet r = null;
		try {
			pstm = conn.prepareStatement(query);
			 pstm.setString(1, aggiunta);
		        pstm.setString(2, token);
			r = pstm.executeQuery();
			if (r.next()) {
				getFromResultSet(r, 2);
				bStatus = true;
			} else {
				String messaggio = Bundle.getInstance().getBundle().getString("msgUserNotExist");
				throw new AuthenticationException(messaggio);
			}
		} finally {
			DatabaseManager.closeResultSet(r);
			DatabaseManager.closeStatement(pstm);
		}
		return bStatus;
	}
    

	/**
	 * Carica le policy di sicurezza applicativa dell'utente. Le policy di
	 * sicurezza applicativa sono quelle policy che definiscono cosa pu fare
	 * l'utente all'interno di una funzione.
	 * 
	 * @param conn
	 */	
	protected synchronized void loadUserPolicy(Connection conn) throws SQLException {
		if (this.policies==null) {
			if (logger.isDebugEnabled()) logger.debug("Load user policy for profile #"+this.profilo.getIdProfilo()+" (one shot)");
			this.policies = new ArrayList<String>();
			
			String query = "select id_policy" +
					      " from cms_32_prof_policy" +
					      " where cms_32_prof_policy.id_profilo = ?";
			if (logSQL.isTraceEnabled()) {
				QueryFormatter.logTrace(logSQL, query);
			}
			
			PreparedStatement pstm = null;
			ResultSet r = null;
			try {
				pstm = conn.prepareStatement(query);
				pstm.setString(1, this.profilo.getIdProfilo());
				r = pstm.executeQuery();
				
				while (r.next()) {
					this.policies.add(r.getString("id_policy"));
				}
			} finally {
				DatabaseManager.closeResultSet(r);
				DatabaseManager.closeStatement(pstm);
			}
		}

	}



	/**
	 * Assegna l'insieme delle policy
	 * 
	 * @param object
	 */
	@SuppressWarnings("unused")
	private void setPolicyList(List<String> table) {
		this.policies = table;
	}

	/**
	 * Restituisce un utente anonimo
	 * 
	 * @return L'utente
	 */
	public static Utente getUtenteAnonimo() {
		Utente utente = new Utente();
		
		utente.setIdUtente("-1");
		utente.setUserName(UNKNWON_USERNAME);
		utente.setCognome("Utente anonimo");
		
		Profilo profilo = new Profilo();
		profilo.setIdProfilo(CMSConstants.PROFILO_ANONIMO);		
		utente.setProfilo(profilo);
		
		utente.setAnonimo(true);
		utente.setLanguage(Parameters.getInstance().getChannelInfo().getDefaultLanguage());		
		return utente;
	}

	/**
	 * Questo metodo serve per verificare che una password sia uguale a quella
	 * dell'utente. Il metodo  utile perch la password momorizzata potrebbe
	 * non essere in chiaro e pertanto  necessario criptarla con lo stesso
	 * criterio prima di effettuare il confronto.
	 * 
	 * @param passwordInChiaro
	 */
	public boolean verificaPassword(String passwordInChiaro) throws Exception {
		if (CMSAdminImplSecurityManager.criptaPassword(passwordInChiaro).equals(this.password)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Se il profilo passato come argomento e' quello preferito allora si
	 * restituisce true. Es: isProfiloPreferito CLIENTE
	 * 
	 * @param user
	 * @return
	 */
	public boolean isProfiloPreferito(String p) {
		boolean granted = false;
		if (hasPolicy(CMSImplPolicyManager.POLICY_PROF_PREF + p)) {
			granted = true;
		}
		return granted;
	}

	// FIXME ma a che serve?
	public String getLogin() {
		return Integer.toString(this.idUtente);
	}

	// FIXME ma a che serve?
	public void setLogin(String login) {
		this.idUtente = Integer.valueOf(login);
	}

	/**
	 * Modifica la passwd dell'oggetto nel database e lo stato dell'utente se il
	 * parametro "stato" vale true.
	 * 
	 * @param conn
	 *            La connessione al DB
	 * @param statoUpdate
	 *            true se deve essere aggiornato anche lo stato
	 * @return Il numero di record inseriti
	 */
	public int updatePasswd(Connection conn, boolean statoUpdate) throws SQLException {
		String query = "update cms_33_utente set password=? ";
		if (statoUpdate) {
			query += ",stato=?";
		}
		query += " where userid=?";
		if (logSQL.isTraceEnabled()) {
			QueryFormatter.logTrace(logSQL, query);
		}
		
		PreparedStatement pstm = null;
		try {
			pstm = conn.prepareStatement(query);
			int i = 1;
			pstm.setString(i++, this.password);
			if (statoUpdate) {
				pstm.setString(i++, this.stato);
			}
			pstm.setInt(i++, this.idUtente);

			int updated = pstm.executeUpdate();
			return updated;
		} finally {
			DatabaseManager.closeStatement(pstm);
		}

	}

	

	public boolean isAnonimo() {
		return anonimo;
	}

	private void setAnonimo(boolean value) {
		anonimo = value;
	}
	
	
	
	
	
	
	public final String getCodedName() throws Exception {
		return SecurityUtils.criptaInStringaByHash(getClass().getName());
	}
	
}