/*
 * Created on 25-feb-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.classes;

import it.softecspa.mvc.utils.RewriteUtils;
import it.softecspa.mvc.utils.StringUtils;
import it.softecspa.portal.Parameters;

/**
 * Classe di utilit per la gestione dei dati di un 'Canale'
 */
public class Channel {

	private int mDBIndex;
	private String mName;
	private String mDescription;
	private int mParentChID;
	private int mPageID;
	private boolean mIsOnlinePreview;
	private boolean mIsOnlineProduz;
	private boolean mWorkflow;
	private int mOrder;
	private String chaType;
	private String chaLink;
	private String chaLinkRelative;
	
	private boolean isLink;
	private boolean isHome;
	private boolean isHttps;
	private String chaPosition;
	private String bookmark;
	private boolean notInMap;
	private int chaLevel;
	private String keywords;
	private String keyDesc;

	
	 
	
	
	public Channel(int p_numDBIndex, String p_strName, String p_strDescr, boolean p_bolIsOnlinePreview, boolean p_bolIsOnlineProduz, boolean p_bolWorkflow, String p_chaType, String p_chaLink, boolean p_isLink, boolean p_isHome, boolean p_isHttps,
				   String p_chaPosition, String bookmark, int chaLevel, String keywords, String keyDesc, Parameters parameters) {
		mDBIndex = p_numDBIndex;
		mParentChID = p_numDBIndex;
		mName = p_strName;
		mDescription = p_strDescr;
		mIsOnlinePreview = p_bolIsOnlinePreview;
		mIsOnlineProduz = p_bolIsOnlineProduz;
		mWorkflow = p_bolWorkflow;
		chaType = p_chaType;
		isLink = p_isLink;
		isHome = p_isHome;
		isHttps = p_isHttps;
		chaPosition = p_chaPosition;
		this.bookmark = bookmark;
		this.chaLevel = chaLevel;
		this.keywords = keywords;
		this.keyDesc = keyDesc;
		this.setChaLink(p_chaLink, parameters);// chiamata che deve stare dopo
		// l'assegnazione di 'isHttps'
	}

	/*----------------------------------------------------------------------
	 Metodi.                                                              
	 ----------------------------------------------------------------------*/
	/**
	 * Restituisce il valore dell'ID del canale.
	 * 
	 * @return L'ID del canale.
	 */
	public int getDBIndex() {
		return mDBIndex;
	}

	/**
	 * Setta il valore dell'ID del canale.
	 * 
	 * @param p_strName
	 *            Il nome da assegnare al canale.
	 */
	public void setDBIndex(int id) {
		mDBIndex = id;
	}

	/**
	 * Restituisce il valore del nome del canale.
	 * 
	 * @return Il nome del canale.
	 */
	public String getName() {
		return mName;
	}

	/**
	 * Setta il valore del nome del canale.
	 * 
	 * @param p_strName
	 *            Il nome da assegnare al canale.
	 */
	public void setName(String p_strName) {
		mName = p_strName;
	}

	/**
	 * Restituisce il valore del nome del bookmark.
	 * 
	 * @return Il nome del canale.
	 */
	public String getBookmark() {
		return bookmark;
	}

	/**
	 * Setta il valore del nome del bookmark.
	 * 
	 * @param bookmark
	 *            Il bookmark da assegnare al canale.
	 */
	public void setBookmark(String bookmark) {
		this.bookmark = bookmark;
	}

	/**
	 * Recupera la descrizione del canale.
	 * 
	 * @return La descrizione del canale.
	 */
	public String getDescription() {
		return mDescription;
	}

	/**
	 * Setta il valore della descrizione del canale.
	 * 
	 * @param p_strDescr
	 *            La descrizione del canale.
	 */
	public void setDescription(String p_strDescr) {
		mDescription = p_strDescr;
	}

	/**
	 * Recupera il tipo del canale (specifica in che menu il canale viene
	 * visualizzato).
	 * 
	 * @return Il tipo del canale.
	 */
	public String getChaType() {
		return chaType;
	}

	/**
	 * Setta il valore del tipo del canale.
	 * 
	 * @param p_cha_type
	 *            Il tipo del canale.
	 */
	public void setChaType(String p_cha_type) {
		chaType = p_cha_type;
	}

	/**
	 * Recupera il valore del link associato al canale.
	 * 
	 * @return Il link del canale.
	 */
	public String getChaLink() {
		return chaLink;
	}

	/**
	 * Setta il valore del link del canale.
	 * 
	 * @param p_cha_link
	 *            Il link del canale.
	 */
	public void setChaLink(String p_cha_link, Parameters parameters) {
		StringBuffer ris = new StringBuffer();
		if (isHome && p_cha_link.lastIndexOf("channel_id=") > -1) {
			p_cha_link = p_cha_link.substring(0, p_cha_link.lastIndexOf("channel_id=") - 1);
		}
		chaLinkRelative = p_cha_link;

		// 15/10/2007 - Pezzino Isabella --> REWRITE
		if (isHome) {
			p_cha_link = "index.htm";
			/*
			 * TODO ricavare CMSWeb e CMSWebAdmin come fa la CMSInitWeb, dal
			 * web.xml
			 */
		} else if (p_cha_link.startsWith("CMSWeb") && !p_cha_link.startsWith("CMSWebAdmin")) {
			ris.append(RewriteUtils.rewriteCMSWeb(StringUtils.stripHtml(mDescription)));
			ris.append("-");
			ris.append(mDBIndex);
			ris.append(".htm");
			p_cha_link = ris.toString();
		}

		ris = new StringBuffer();

		if (isHttps) {
			ris.append("https://" + parameters.getChannelInfo().getDomainName()
					 			  + parameters.getChannelInfo().getPortHTTPS() 
					 			  + parameters.getChannelInfo().getContextName());
		} else {
			ris.append("http://" + parameters.getChannelInfo().getDomainName()
								 + parameters.getChannelInfo().getPortHTTP() 
								 + parameters.getChannelInfo().getContextName());
		}
		
		ris.append("/");
		ris.append(p_cha_link);

		chaLink = ris.toString();
	}

	public String getChaLinkRelative() {
		return chaLinkRelative;
	}

	/**
	 * Ricava l'ID del canale padre.
	 * 
	 * @return L'ID ddl canale padre.
	 */
	public int getParentChannelID() {
		return mParentChID;
	}

	/**
	 * Controlla se il canale ha un canale padre.
	 * 
	 * @return TRUE se il canale ha un padre.
	 */
	public boolean hasParentChannel() {
		return (mParentChID > 0);
	}

	/**
	 * Setta il valore dell'ID del canale padre.
	 * 
	 * @param p_numID
	 *            L'ID del canale padre.
	 */
	public void setParentChannelID(int p_numID) {

		mParentChID = p_numID;
	}

	/**
	 * Recupera l'ID della pagina associata al canale.
	 * 
	 * @return L'ID della pagina associata.
	 */
	public int getPageID() {
		return mPageID;
	}

	/**
	 * Controlla se al canale  associata una pagina.
	 * 
	 * @return TRUE se al canale  associata una pagina.
	 */
	public boolean hasPage() {
		return (mPageID > 0);
	}

	/**
	 * Setta il valore dell'ID della pagina associata al canale.
	 * 
	 * @param p_numID
	 *            L'ID della pagina.
	 */
	public void setPageID(int p_numID) {

		mPageID = p_numID;
	}

	/**
	 * Controlla se il canale deve essere escluso dalla mappa del sito.
	 * 
	 * @return TRUE se il canale deve essere escluso dalla mappa.
	 */
	public boolean notInMap() {
		return notInMap;
	}

	/**
	 * Setta il valore dell'attributo notInMap.
	 * 
	 * @param notInMap
	 */
	public void setNotInMap(boolean notInMap) {
		this.notInMap = notInMap;
	}

	public boolean hasWorkflow() {
		return mWorkflow;
	}

	public void setWorkflow(boolean p_bolWorkflow) {
		mWorkflow = p_bolWorkflow;
	}

	/**
	 * Recupera l'ordine del canale all'interno del suo livello di
	 * visualizzazione.
	 * 
	 * @return L'ordine del canale nel livello.
	 */
	public int getOrder() {
		return mOrder;
	}

	public void setOrder(int p_numOrder) {
		mOrder = p_numOrder;
	}

	public boolean isMIsOnlinePreview() {
		return mIsOnlinePreview;
	}

	public void setMIsOnlinePreview(boolean isOnlinePreview) {
		mIsOnlinePreview = isOnlinePreview;
	}

	public boolean isMIsOnlineProduz() {
		return mIsOnlineProduz;
	}

	public void setMIsOnlineProduz(boolean isOnlineProduz) {
		mIsOnlineProduz = isOnlineProduz;
	}

	/**
	 * Controlla se il canale  un link o un contenuto del CMS.
	 * 
	 * @return TRUE se il canale  un link.
	 */
	public boolean isLink() {
		return isLink;
	}

	/**
	 * Specifica se il canale  un link o un contentuo del CMS.
	 * 
	 * @param isLink
	 *            TRUE se il canale  un link.
	 */
	public void setLink(boolean isLink) {
		this.isLink = isLink;
	}

	/**
	 * Controlla se il canale  la Home del portale.
	 * 
	 * @return TRUE se  la Home.
	 */
	public boolean isHome() {
		return isHome;
	}

	/**
	 * Specifica se il canale  la Home del portale.
	 * 
	 * @param isHome
	 *            TRUE se  la radice.
	 */
	public void setHome(boolean isHome) {
		this.isHome = isHome;
	}

	/**
	 * Controlla se il canale  un https o un contenuto del CMS.
	 * 
	 * @return TRUE se il canale  un https.
	 */
	public boolean isHttps() {
		return isHttps;
	}

	/**
	 * Specifica se il canale  un https o un contentuo del CMS.
	 * 
	 * @param isHttps
	 *            TRUE se il canale  un https.
	 */
	public void setHttps(boolean isHttps) {
		this.isHttps = isHttps;
	}

	/**
	 * Recupera la posizione (il menu) in cui il canale deve essere
	 * visualizzato.
	 * 
	 * @return La posizione del canale.
	 */
	public String getChaPosition() {
		return chaPosition;
	}

	/**
	 * Setta la posizione del canale.
	 * 
	 * @param chaPosition
	 *            La posizione del canale.
	 */
	public void setChaPosition(String chaPosition) {
		this.chaPosition = chaPosition;
	}

	/**
	 * Recupera il livello del canale.
	 * 
	 * @return Il livello del canale.
	 */
	public int getChaLevel() {
		return chaLevel;
	}

	/**
	 * Setta il livello del canale.
	 * 
	 * @param chaLevel
	 *            Il livello del canale.
	 */
	public void setChaLevel(int chaLevel) {
		this.chaLevel = chaLevel;
	}

	public String getKeyDesc() {
		return keyDesc != null ? keyDesc : "";
	}

	public void setKeyDesc(String keyDesc) {
		this.keyDesc = keyDesc;
	}

	public String getKeywords() {
		return keywords != null ? keywords : "";
	}

	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	public boolean hasKeywords() {
		return (keywords != null && !keywords.trim().equals(""));
	}

	/*
	 * restituisce i parametri da inserire nella chiamata ajax
	 */
	public String[] getParamsAjax() {

		String nameUrl = getChaLink();

		nameUrl = nameUrl.substring(nameUrl.lastIndexOf("/") + 1);
		String[] params = nameUrl.split("\\?");
		String nomeServlet = params[0];
		String channelID = params[1].split("=")[1];

		String[] paramsAjax = { nomeServlet, channelID };

		return paramsAjax;

	}
}
