/*
 * Created on 25-feb-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package it.softecspa.jwebber.common.classes;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.jwebber.CMSUtilities;
import it.softecspa.jwebber.DateUtil;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;

/**
 * Classe di utilit per la gestione del filtro per la visualizzazione dei
 * contenuti.
 */
public class CntFilter {

	private Date mCreateDate = null;
	private String operator_data = "";
	private String mOnline = "";
	private String mToApprove = "";
	private List<CntWhereCondition> arrWhereConditions = null;
	private int mCType = 0;
	private String mOrderBy = "";
	private String mOrderDir = null;
	// ZZ
	private String pag = "0";
	private String rxp = CMSConstants.CMS_CONTENTS_RXP;

	/*----------------------------------------------------------------------
	Costruttore.                                                         
	----------------------------------------------------------------------*/
	public CntFilter(List<CntWhereCondition> arrWhereConditions, String strCType, String strCreateDate, String operator_data, String strOnline, String strToApprove, String pag, String rxp) {
		if (CMSUtilities.isIntValue(strCType)) {
			mCType = Integer.parseInt(strCType);
		}
		try {
			mCreateDate = DateUtil.string2Date(strCreateDate, "dd/MM/yyyy");
			this.operator_data = operator_data;
		} catch (Exception e) {
			mCreateDate = null;
			this.operator_data = CntWhereCondition.OPERATOR_EQUAL;
		}

		if (pag != null)
			this.pag = pag;
		if (rxp != null)
			this.rxp = rxp;

		this.arrWhereConditions = arrWhereConditions;
		mOnline = (strOnline != null ? strOnline : "");
		mToApprove = (strToApprove != null ? strToApprove : "");
		mOrderBy = "d12_cmd_dat_creaz";
		mOrderDir = "ASC";

	}

	/*----------------------------------------------------------------------
	  Metodi.                                                              
	  ----------------------------------------------------------------------*/
	public void setOrderBy(String strOrderBy, String strOrderDir) {
		if (strOrderBy != null && !strOrderBy.trim().equals("")) {
			mOrderBy = strOrderBy;
		} else {
			mOrderBy = "d12_cmd_dat_creaz";
		}

		if (strOrderDir.length() == 0 || strOrderDir.equals("ASC")) {
			mOrderDir = "ASC";
		} else {
			mOrderDir = "DESC";
		}
	}

	public String getPag() {
		return pag;
	}

	public void setPag(String pag) {
		this.pag = pag;
	}

	public String getRxp() {
		return rxp;
	}

	public void setRxp(String rxp) {
		this.rxp = rxp;
	}

	@SuppressWarnings("rawtypes")
	public String getFilter(Vector arrCTypes) {
		String whereCondition = "";
		if (arrWhereConditions != null) {
			for (int i = 0; i < arrWhereConditions.size(); i++) {
				whereCondition += " AND ";
				CntWhereCondition condition = (CntWhereCondition) arrWhereConditions.get(i);
				CntAlias alias = condition.getAlias();
				whereCondition += " lower(" + alias.getContentColumnName() + ")";
				whereCondition += " " + condition.getOperator();
				if (alias.getTypeName().equals("cntNumeroFloat") || alias.getTypeName().equals("cntNumeroIntero")) {
					whereCondition += " " + condition.getValue();
				} else {
					if (condition.getOperator().equals(CntWhereCondition.OPERATOR_LIKE)) {
						whereCondition += " lower('%" + condition.getValue() + "%')";
					} else {
						whereCondition += " lower('" + condition.getValue() + "')";
					}
				}
			}
		}
		if (mCreateDate != null) {
			if (operator_data.equals(CntWhereCondition.OPERATOR_EQUAL)) {
				Calendar cal = Calendar.getInstance();
				cal.setTime(mCreateDate);
				int year = cal.get(Calendar.YEAR);
				int month = cal.get(Calendar.MONTH) + 1;
				int day = cal.get(Calendar.DAY_OF_MONTH);
				whereCondition += " and year(d12_cmd_dat_creaz) = " + year;
				whereCondition += " and month(d12_cmd_dat_creaz) = " + month;
				whereCondition += " and dayofmonth(d12_cmd_dat_creaz) = " + day;
			} else {
				whereCondition += " and d12_cmd_dat_creaz " + operator_data + " '" + DateUtil.date2String(mCreateDate) + "' ";
			}
		}

		if (!mOnline.equals("")) {
			whereCondition += " and n12_cmd_online = " + mOnline;
		}

		if (!mToApprove.equals("")) {
			// ZZ per far si che la ricerca per to approve approved funzioni, 
			// una data e veniva messa uguale a 1 o 0 ...
			// whereCondition += " and d12_cmd_approved = " + mToApprove;
			if ("1".equals(mToApprove)) {
				whereCondition += " and d12_cmd_approved is NULL";
			} else if ("0".equals(mToApprove)) {
				whereCondition += " and (NOT (d12_cmd_approved is NULL))";
			}

		}

		if (mCType > 0) {
			whereCondition += " and n11_tic_oid = " + String.valueOf(mCType);
		} else {
			whereCondition += " and n11_tic_oid IN (0";

			for (int i = 0; i < arrCTypes.size(); i++) {
				whereCondition += "," + ((ContentType) arrCTypes.get(i)).getDBIndex();
			}
			whereCondition += ")";
		}
		return whereCondition;
	}

	public String getFilterOrderBy() {
		return mOrderBy + " " + mOrderDir;
	}

	public String getFilterPage() {
		String strPage = "";
		int p = 0;
		int r = 0;
		if (CMSUtilities.isIntValue(pag) && CMSUtilities.isIntValue(rxp)) {
			p = Integer.parseInt(pag);
			r = Integer.parseInt(rxp);
		}

		if (r != 0) {
			strPage = "limit " + (p * r) + "," + r;
		}

		return strPage;
	}

	/**
	 * @return Returns the mCType.
	 */
	public int getMCType() {
		return mCType;
	}

	/**
	 * @param type
	 *            The mCType to set.
	 */
	public void setMCType(int type) {
		mCType = type;
	}
}